/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.purchase.zzb;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzh;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzfw;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zzid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@zzgr
public class zzc
extends zzhz
implements ServiceConnection {
    private final Object zzpd = new Object();
    private boolean zzCB = false;
    private Context mContext;
    private zzfw zzCC;
    private zzb zzCD;
    private zzh zzCE;
    private List<zzf> zzCF = null;
    private zzk zzCG;

    public zzc(Context context, zzfw zzfw2, zzk zzk2) {
        this(context, zzfw2, zzk2, new zzb(context), zzh.zzw(context.getApplicationContext()));
    }

    zzc(Context context, zzfw zzfw2, zzk zzk2, zzb zzb2, zzh zzh2) {
        this.mContext = context;
        this.zzCC = zzfw2;
        this.zzCG = zzk2;
        this.zzCD = zzb2;
        this.zzCE = zzh2;
        this.zzCF = this.zzCE.zzg(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbn() {
        Object object = this.zzpd;
        synchronized (object) {
            Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            intent.setPackage("com.android.vending");
            com.google.android.gms.common.stats.zzb.zzqh().zza(this.mContext, intent, this, 1);
            this.zze(SystemClock.elapsedRealtime());
            com.google.android.gms.common.stats.zzb.zzqh().zza(this.mContext, this);
            this.zzCD.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzpd;
        synchronized (object) {
            com.google.android.gms.common.stats.zzb.zzqh().zza(this.mContext, this);
            this.zzCD.destroy();
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        com.google.android.gms.ads.internal.util.client.zzb.zzaG("In-app billing service disconnected.");
        this.zzCD.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName name, IBinder service) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzCD.zzN(service);
            this.zzfm();
            this.zzCB = true;
            this.zzpd.notify();
        }
    }

    protected void zzfm() {
        int n;
        Bundle bundle;
        if (this.zzCF.isEmpty()) {
            return;
        }
        HashMap<String, zzf> hashMap = new HashMap<String, zzf>();
        for (zzf object2 : this.zzCF) {
            hashMap.put(object2.zzCS, object2);
        }
        Object object3 = null;
        while ((bundle = this.zzCD.zzj(this.mContext.getPackageName(), (String)object3)) != null && (n = zzp.zzbF().zzc(bundle)) == 0) {
            ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            object3 = bundle.getString("INAPP_CONTINUATION_TOKEN");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!hashMap.containsKey(arrayList.get(i))) continue;
                String string2 = (String)arrayList.get(i);
                String string3 = (String)arrayList2.get(i);
                String string4 = (String)arrayList3.get(i);
                zzf zzf2 = (zzf)hashMap.get(string2);
                String string5 = zzp.zzbF().zzao(string3);
                if (!zzf2.zzCR.equals(string5)) continue;
                this.zza(zzf2, string3, string4);
                hashMap.remove(string2);
            }
            if (object3 != null && !hashMap.isEmpty()) continue;
        }
        for (String string6 : hashMap.keySet()) {
            this.zzCE.zza((zzf)hashMap.get(string6));
        }
    }

    protected void zza(final zzf zzf2, String string2, String string3) {
        final Intent intent = new Intent();
        zzp.zzbF();
        intent.putExtra("RESPONSE_CODE", 0);
        zzp.zzbF();
        intent.putExtra("INAPP_PURCHASE_DATA", string2);
        zzp.zzbF();
        intent.putExtra("INAPP_DATA_SIGNATURE", string3);
        zzid.zzIE.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (zzc.this.zzCG.zza(zzf2.zzCR, -1, intent)) {
                        zzc.this.zzCC.zza(new zzg(zzc.this.mContext, zzf2.zzCS, true, -1, intent, zzf2));
                    } else {
                        zzc.this.zzCC.zza(new zzg(zzc.this.mContext, zzf2.zzCS, false, -1, intent, zzf2));
                    }
                }
                catch (RemoteException remoteException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzaH("Fail to verify and dispatch pending transaction");
                }
            }
        });
    }

    private void zze(long l2) {
        do {
            if (this.zzf(l2)) continue;
            com.google.android.gms.ads.internal.util.client.zzb.v("Timeout waiting for pending transaction to be processed.");
        } while (!this.zzCB);
    }

    private boolean zzf(long l2) {
        long l3 = 60000L - (SystemClock.elapsedRealtime() - l2);
        if (l3 <= 0L) {
            return false;
        }
        try {
            this.zzpd.wait(l3);
        }
        catch (InterruptedException interruptedException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("waitWithTimeout_lock interrupted");
        }
        return true;
    }
}

