/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbk;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzee;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zzid;
import org.json.JSONException;
import org.json.JSONObject;

@zzgr
public class zzb
extends zzhz
implements zzc.zza {
    private final zza.zza zzEe;
    private final AdRequestInfoParcel.zza zzEf;
    private final Object zzDh = new Object();
    private final Context mContext;
    private final zzan zzwL;
    private AdRequestInfoParcel zzzz;
    private Runnable zzDg;
    zzhz zzEg;
    AdResponseParcel zzDf;
    zzee zzzA;

    public zzb(Context context, AdRequestInfoParcel.zza zza2, zzan zzan2, zza.zza zza3) {
        this.zzEe = zza3;
        this.mContext = context;
        this.zzEf = zza2;
        this.zzwL = zzan2;
    }

    zzhz zzb(AdRequestInfoParcel adRequestInfoParcel) {
        return zzc.zza(this.mContext, adRequestInfoParcel, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbn() {
        com.google.android.gms.ads.internal.util.client.zzb.zzaF("AdLoaderBackgroundTask started.");
        zzaj zzaj2 = this.zzwL.zzab();
        String string2 = zzaj2.zzb(this.mContext);
        this.zzDg = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzDh;
                synchronized (object) {
                    if (zzb.this.zzEg == null) {
                        return;
                    }
                    zzb.this.onStop();
                    zzb.this.zzc(2, "Timed out waiting for ad response.");
                }
            }
        };
        zzid.zzIE.postDelayed(this.zzDg, zzby.zzvv.get().longValue());
        long l2 = zzp.zzbz().elapsedRealtime();
        this.zzzz = new AdRequestInfoParcel(this.zzEf, string2, l2);
        Object object = this.zzDh;
        synchronized (object) {
            this.zzEg = this.zzb(this.zzzz);
            if (this.zzEg == null) {
                this.zzc(0, "Could not start the ad request service.");
                zzid.zzIE.removeCallbacks(this.zzDg);
            }
        }
    }

    private void zzc(int n, String string2) {
        if (n == 3 || n == -1) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaG(string2);
        } else {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH(string2);
        }
        this.zzDf = this.zzDf == null ? new AdResponseParcel(n) : new AdResponseParcel(n, this.zzDf.zzzc);
        zzhs.zza zza2 = new zzhs.zza(this.zzzz, this.zzDf, this.zzzA, null, n, -1L, this.zzDf.zzEO, null);
        this.zzEe.zza(zza2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        com.google.android.gms.ads.internal.util.client.zzb.zzaF("Received ad response.");
        this.zzDf = adResponseParcel;
        long l2 = zzp.zzbz().elapsedRealtime();
        Object object = this.zzDh;
        synchronized (object) {
            this.zzEg = null;
        }
        object = null;
        try {
            if (this.zzDf.errorCode != -2 && this.zzDf.errorCode != -3) {
                throw new zza("There was a problem getting an ad response. ErrorCode: " + this.zzDf.errorCode, this.zzDf.errorCode);
            }
            this.zzfG();
            if (this.zzzz.zzqn.zztg != null) {
                object = this.zzc(this.zzzz);
            }
        }
        catch (zza zza2) {
            this.zzc(zza2.getErrorCode(), zza2.getMessage());
            zzid.zzIE.removeCallbacks(this.zzDg);
            return;
        }
        this.zzw(this.zzDf.zzEU);
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)this.zzDf.zzES)) {
            try {
                jSONObject = new JSONObject(this.zzDf.zzES);
            }
            catch (Exception exception) {
                com.google.android.gms.ads.internal.util.client.zzb.zzb("Error parsing the JSON for Active View.", exception);
            }
        }
        zzhs.zza zza3 = new zzhs.zza(this.zzzz, this.zzDf, this.zzzA, (AdSizeParcel)object, -2, l2, this.zzDf.zzEO, jSONObject);
        this.zzEe.zza(zza3);
        zzid.zzIE.removeCallbacks(this.zzDg);
    }

    protected void zzw(boolean bl) {
        zzp.zzby().zzA(bl);
        zzbk zzbk2 = zzp.zzby().zzE(this.mContext);
        if (zzbk2 != null && !zzbk2.isAlive()) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaF("start fetching content...");
            zzbk2.zzct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzDh;
        synchronized (object) {
            if (this.zzEg != null) {
                this.zzEg.cancel();
            }
        }
    }

    protected void zzfG() throws zza {
        if (this.zzDf.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzDf.body)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzp.zzby().zza(this.mContext, this.zzDf.zzEv);
        if (this.zzDf.zzEK) {
            try {
                this.zzzA = new zzee(this.zzDf.body);
            }
            catch (JSONException jSONException) {
                throw new zza("Could not parse mediation config: " + this.zzDf.body, 0);
            }
        }
    }

    protected AdSizeParcel zzc(AdRequestInfoParcel adRequestInfoParcel) throws zza {
        int n;
        int n2;
        if (this.zzDf.zzEN == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzDf.zzEN.split("x");
        if (stringArray.length != 2) {
            throw new zza("Invalid ad size format from the ad response: " + this.zzDf.zzEN, 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new zza("Invalid ad size number from the ad response: " + this.zzDf.zzEN, 0);
        }
        for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzqn.zztg) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / f) : adSizeParcel.width;
            int n5 = n3 = adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / f) : adSizeParcel.height;
            if (n2 != n4 || n != n3) continue;
            return new AdSizeParcel(adSizeParcel, adRequestInfoParcel.zzqn.zztg);
        }
        throw new zza("The ad size from the ad response was not one of the requested sizes: " + this.zzDf.zzEN, 0);
    }

    @zzgr
    static final class zza
    extends Exception {
        private final int zzDv;

        public zza(String string2, int n) {
            super(string2);
            this.zzDv = n;
        }

        public int getErrorCode() {
            return this.zzDv;
        }
    }
}

