/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzdl;
import com.google.android.gms.internal.zzdp;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zziz;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzgr
public class zzm
extends zzhz {
    static final long zzFi = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zzpy = new Object();
    private static boolean zzFj = false;
    private static zzdz zzFk = null;
    private static zzdl zzFl = null;
    private static zzdp zzFm = null;
    private static zzdk zzFn = null;
    private final zza.zza zzEe;
    private final AdRequestInfoParcel.zza zzEf;
    private final Object zzDh = new Object();
    private final Context mContext;
    private zzdz.zzd zzFo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzm(Context context, AdRequestInfoParcel.zza zza2, zza.zza zza3) {
        super(true);
        this.zzEe = zza3;
        this.mContext = context;
        this.zzEf = zza2;
        Object object = zzpy;
        synchronized (object) {
            if (!zzFj) {
                zzFm = new zzdp();
                zzFl = new zzdl(context.getApplicationContext(), zza2.zzqj);
                zzFn = new zzc();
                zzFk = new zzdz(this.mContext.getApplicationContext(), this.zzEf.zzqj, zzby.zzul.get(), new zzb(), new zza());
                zzFj = true;
            }
        }
    }

    protected static void zzc(zzbb zzbb2) {
        zzbb2.zza("/loadAd", zzFm);
        zzbb2.zza("/fetchHttpRequest", zzFl);
        zzbb2.zza("/invalidRequest", zzFn);
    }

    protected static void zzd(zzbb zzbb2) {
        zzbb2.zzb("/loadAd", zzFm);
        zzbb2.zzb("/fetchHttpRequest", zzFl);
        zzbb2.zzb("/invalidRequest", zzFn);
    }

    @Override
    public void zzbn() {
        com.google.android.gms.ads.internal.util.client.zzb.zzaF("SdkLessAdLoaderBackgroundTask started.");
        AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzEf, null, -1L);
        AdResponseParcel adResponseParcel = this.zzf(adRequestInfoParcel);
        long l2 = zzp.zzbz().elapsedRealtime();
        final zzhs.zza zza2 = new zzhs.zza(adRequestInfoParcel, adResponseParcel, null, null, adResponseParcel.errorCode, l2, adResponseParcel.zzEO, null);
        com.google.android.gms.ads.internal.util.client.zza.zzJt.post(new Runnable(){

            @Override
            public void run() {
                zzm.this.zzEe.zza(zza2);
                if (zzm.this.zzFo != null) {
                    zzm.this.zzFo.release();
                    zzm.this.zzFo = null;
                }
            }
        });
    }

    private AdResponseParcel zzf(AdRequestInfoParcel adRequestInfoParcel) {
        JSONObject jSONObject;
        final String string2 = UUID.randomUUID().toString();
        final JSONObject jSONObject2 = this.zza(adRequestInfoParcel, string2);
        if (jSONObject2 == null) {
            return new AdResponseParcel(0);
        }
        long l2 = zzp.zzbz().elapsedRealtime();
        Future<JSONObject> future = zzFm.zzY(string2);
        com.google.android.gms.ads.internal.util.client.zza.zzJt.post(new Runnable(){

            @Override
            public void run() {
                zzm.this.zzFo = zzFk.zzdO();
                zzm.this.zzFo.zza(new zzis.zzc<zzbe>(){

                    public void zzb(zzbe zzbe2) {
                        try {
                            zzbe2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            com.google.android.gms.ads.internal.util.client.zzb.zzb("Error requesting an ad url", exception);
                            zzFm.zzZ(string2);
                        }
                    }

                    @Override
                    public /* synthetic */ void zzc(Object object) {
                        this.zzb((zzbe)object);
                    }
                }, new zzis.zza(){

                    @Override
                    public void run() {
                        zzFm.zzZ(string2);
                    }
                });
            }
        });
        long l3 = zzFi - (zzp.zzbz().elapsedRealtime() - l2);
        try {
            jSONObject = future.get(l3, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new AdResponseParcel(-1);
        }
        catch (TimeoutException timeoutException) {
            return new AdResponseParcel(2);
        }
        catch (ExecutionException executionException) {
            return new AdResponseParcel(0);
        }
        if (jSONObject == null) {
            return new AdResponseParcel(-1);
        }
        AdResponseParcel adResponseParcel = zzgu.zza(this.mContext, adRequestInfoParcel, jSONObject.toString());
        if (adResponseParcel.errorCode != -3 && TextUtils.isEmpty((CharSequence)adResponseParcel.body)) {
            return new AdResponseParcel(3);
        }
        return adResponseParcel;
    }

    private JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, String string2) {
        Bundle bundle = adRequestInfoParcel.zzEn.extras.getBundle("sdk_less_server_data");
        String string3 = adRequestInfoParcel.zzEn.extras.getString("sdk_less_network_id");
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = zzgu.zza(this.mContext, adRequestInfoParcel, zzp.zzbB().zzC(this.mContext), null, null, new zzbr(zzby.zzul.get()), null, null, new ArrayList<String>());
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo(this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException exception) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Cannot get advertising id info", exception);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("network_id", string3);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzp.zzbv().zzz(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzDh;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zza.zzJt.post(new Runnable(){

                @Override
                public void run() {
                    if (zzm.this.zzFo != null) {
                        zzm.this.zzFo.release();
                        zzm.this.zzFo = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzdz.zzb<zzbb> {
        public void zza(zzbb zzbb2) {
            zzm.zzd(zzbb2);
        }

        @Override
        public /* synthetic */ void zzc(Object object) {
            this.zza((zzbb)object);
        }
    }

    public static class zzb
    implements zzdz.zzb<zzbb> {
        public void zza(zzbb zzbb2) {
            zzm.zzc(zzbb2);
        }

        @Override
        public /* synthetic */ void zzc(Object object) {
            this.zza((zzbb)object);
        }
    }

    public static class zzc
    implements zzdk {
        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            String string2 = map.get("request_id");
            String string3 = map.get("errors");
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Invalid request: " + string3);
            zzFm.zzZ(string2);
        }
    }
}

