/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.RemoteException;
import android.view.Window;
import com.google.android.gms.ads.internal.InterstitialAdParameterParcel;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzc;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzem;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zziz;

@zzgr
public class zzk
extends zzc
implements zzdo {
    protected transient boolean zzpk = false;
    private boolean zzpl;
    private float zzpm;
    private String zzpn = "background" + this.hashCode() + "." + "png";

    public zzk(Context context, AdSizeParcel adSizeParcel, String string2, zzem zzem2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        super(context, adSizeParcel, string2, zzem2, versionInfoParcel, zzd2);
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzcg zzcg2) {
        if (this.zzot.zzqo != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("An interstitial is already loading. Aborting.");
            return false;
        }
        return super.zza(adRequestParcel, zzcg2);
    }

    @Override
    protected zziz zza(zzhs.zza zza2, zze zze2) {
        zziz zziz2 = null;
        zziz2 = zzp.zzbw().zza(this.zzot.context, this.zzot.zzqn, false, false, this.zzot.zzqi, this.zzot.zzqj, this.zzoo, this.zzow);
        zziz2.zzhe().zzb(this, null, this, this, zzby.zzvc.get(), this, this, zze2, null);
        zziz2.zzaJ(zza2.zzHC.zzEC);
        return zziz2;
    }

    @Override
    protected boolean zza(AdRequestParcel adRequestParcel, zzhs zzhs2, boolean bl) {
        if (this.zzot.zzbN() && zzhs2.zzBD != null) {
            zzp.zzbx().zza(zzhs2.zzBD.getWebView());
        }
        return this.zzos.zzbp();
    }

    @Override
    public boolean zza(zzhs zzhs2, zzhs zzhs3) {
        if (!super.zza(zzhs2, zzhs3)) {
            return false;
        }
        if (!this.zzot.zzbN() && this.zzot.zzqG != null && zzhs3.zzHw != null) {
            zzaz zzaz2 = this.zzov.zza(this.zzot.zzqn, zzhs3, this.zzot.zzqG);
        }
        return true;
    }

    @Override
    public void zzaW() {
        this.recordImpression();
        super.zzaW();
    }

    @Override
    protected boolean zzaQ() {
        this.zzbm();
        return super.zzaQ();
    }

    @Override
    public void zzd(boolean bl) {
        this.zzot.zzpt = bl;
    }

    @Override
    public void zza(boolean bl, float f) {
        this.zzpl = bl;
        this.zzpm = f;
    }

    @Override
    public void showInterstitial() {
        Object object;
        String string2;
        zzx.zzci("showInterstitial must be called on the main UI thread.");
        if (this.zzot.zzqo == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("The interstitial has not loaded.");
            return;
        }
        if (zzby.zzvo.get().booleanValue()) {
            String string3 = string2 = this.zzot.context.getApplicationContext() != null ? this.zzot.context.getApplicationContext().getPackageName() : this.zzot.context.getPackageName();
            if (!this.zzpk) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("It is not recommended to show an interstitial before onAdLoaded completes.");
                object = new Bundle();
                object.putString("appid", string2);
                object.putString("action", "show_interstitial_before_load_finish");
                this.zzb((Bundle)object);
            }
            if (!zzp.zzbv().zzN(this.zzot.context)) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("It is not recommended to show an interstitial when app is not in foreground.");
                object = new Bundle();
                object.putString("appid", string2);
                object.putString("action", "show_interstitial_app_not_in_foreground");
                this.zzb((Bundle)object);
            }
        }
        if (this.zzot.zzbO()) {
            return;
        }
        if (this.zzot.zzqo.zzEK) {
            try {
                this.zzot.zzqo.zzzv.showInterstitial();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not show interstitial.", remoteException);
                this.zzbm();
            }
        } else {
            if (this.zzot.zzqo.zzBD == null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("The interstitial failed to load.");
                return;
            }
            if (this.zzot.zzqo.zzBD.zzhi()) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("The interstitial is already showing.");
                return;
            }
            this.zzot.zzqo.zzBD.zzC(true);
            if (this.zzot.zzqo.zzHw != null) {
                this.zzov.zza(this.zzot.zzqn, this.zzot.zzqo);
            }
            Object object2 = string2 = this.zzot.zzpt ? zzp.zzbv().zzO(this.zzot.context) : null;
            if (zzby.zzvz.get().booleanValue() && string2 != null) {
                new zzb((Bitmap)string2, this.zzpn).zzgz();
            } else {
                object = new InterstitialAdParameterParcel(this.zzot.zzpt, this.zzbl(), null, false, 0.0f);
                int n = this.zzot.zzqo.zzBD.getRequestedOrientation();
                if (n == -1) {
                    n = this.zzot.zzqo.orientation;
                }
                AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(this, this, this, this.zzot.zzqo.zzBD, n, this.zzot.zzqj, this.zzot.zzqo.zzEP, (InterstitialAdParameterParcel)object);
                zzp.zzbt().zza(this.zzot.context, adOverlayInfoParcel);
            }
        }
    }

    private void zzb(Bundle bundle) {
        zzp.zzbv().zzb(this.zzot.context, this.zzot.zzqj.zzJu, "gmob-apps", bundle, false);
    }

    protected boolean zzbl() {
        if (!(this.zzot.context instanceof Activity)) {
            return false;
        }
        Window window = ((Activity)this.zzot.context).getWindow();
        if (window == null || window.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        window.getDecorView().getGlobalVisibleRect(rect, null);
        window.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    @Override
    protected boolean zzaT() {
        if (super.zzaT()) {
            this.zzpk = true;
            return true;
        }
        return false;
    }

    private void zzbm() {
        new zza(this.zzpn).zzgz();
        if (this.zzot.zzbN()) {
            this.zzot.zzbK();
            this.zzot.zzqo = null;
            this.zzot.zzpt = false;
            this.zzpk = false;
        }
    }

    @zzgr
    private class zza
    extends zzhz {
        private final String zzpo;

        public zza(String string2) {
            this.zzpo = string2;
        }

        @Override
        public void zzbn() {
            zzp.zzbv().zzh(zzk.this.zzot.context, this.zzpo);
        }

        @Override
        public void onStop() {
        }
    }

    @zzgr
    private class zzb
    extends zzhz {
        private final Bitmap zzpq;
        private final String zzpo;

        public zzb(Bitmap bitmap, String string2) {
            this.zzpq = bitmap;
            this.zzpo = string2;
        }

        @Override
        public void zzbn() {
            boolean bl = zzk.this.zzot.zzpt ? zzp.zzbv().zza(zzk.this.zzot.context, this.zzpq, this.zzpo) : false;
            InterstitialAdParameterParcel interstitialAdParameterParcel = new InterstitialAdParameterParcel(zzk.this.zzot.zzpt, zzk.this.zzbl(), bl ? this.zzpo : null, zzk.this.zzpl, zzk.this.zzpm);
            int n = zzk.this.zzot.zzqo.zzBD.getRequestedOrientation();
            if (n == -1) {
                n = zzk.this.zzot.zzqo.orientation;
            }
            final AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(zzk.this, zzk.this, zzk.this, zzk.this.zzot.zzqo.zzBD, n, zzk.this.zzot.zzqj, zzk.this.zzot.zzqo.zzEP, interstitialAdParameterParcel);
            zzid.zzIE.post(new Runnable(){

                @Override
                public void run() {
                    zzp.zzbt().zza(zzk.this.zzot.context, adOverlayInfoParcel);
                }
            });
        }

        @Override
        public void onStop() {
        }
    }
}

