/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzLv;
    private final Tracker zzLw;
    private final Context mContext;
    private ExceptionParser zzLx;
    private GoogleAnalytics zzLy;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzLv = originalHandler;
        this.zzLw = tracker;
        this.zzLx = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        zzae.v("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzLx;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzLx = exceptionParser;
    }

    GoogleAnalytics zzhK() {
        if (this.zzLy == null) {
            this.zzLy = GoogleAnalytics.getInstance(this.mContext);
        }
        return this.zzLy;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Object object;
        String string2 = "UncaughtException";
        if (this.zzLx != null) {
            object = t != null ? t.getName() : null;
            string2 = this.zzLx.getDescription((String)object, e);
        }
        zzae.v("Reporting uncaught exception: " + string2);
        this.zzLw.send(new HitBuilders.ExceptionBuilder().setDescription(string2).setFatal(true).build());
        object = this.zzhK();
        ((GoogleAnalytics)object).dispatchLocalHits();
        ((GoogleAnalytics)object).zzhO();
        if (this.zzLv != null) {
            zzae.v("Passing exception to the original handler");
            this.zzLv.uncaughtException(t, e);
        }
    }

    Thread.UncaughtExceptionHandler zzhL() {
        return this.zzLv;
    }
}

