/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

public class zza
extends zzd {
    public static boolean zzMq;
    private AdvertisingIdClient.Info zzMr;
    private final zzaj zzMs;
    private String zzMt;
    private boolean zzMu = false;
    private Object zzMv = new Object();

    zza(zzf zzf2) {
        super(zzf2);
        this.zzMs = new zzaj(zzf2.zzit());
    }

    @Override
    protected void zzhR() {
    }

    public boolean zzic() {
        this.zziE();
        AdvertisingIdClient.Info info = this.zzih();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public String zzig() {
        this.zziE();
        AdvertisingIdClient.Info info = this.zzih();
        String string2 = null;
        if (info != null) {
            string2 = info.getId();
        }
        if (TextUtils.isEmpty(string2)) {
            return null;
        }
        return string2;
    }

    private synchronized AdvertisingIdClient.Info zzih() {
        if (this.zzMs.zzv(1000L)) {
            this.zzMs.start();
            AdvertisingIdClient.Info info = this.zzii();
            if (this.zza(this.zzMr, info)) {
                this.zzMr = info;
            } else {
                this.zzbe("Failed to reset client id on adid change. Not using adid");
                this.zzMr = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzMr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string2;
        String string3 = string2 = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return true;
        }
        String string4 = this.zziz().zzjt();
        Object object = this.zzMv;
        synchronized (object) {
            String string5;
            if (!this.zzMu) {
                this.zzMt = this.zzij();
                this.zzMu = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzMt)) {
                String string6 = string5 = info == null ? null : info.getId();
                if (string5 == null) {
                    return this.zzaZ(string2 + string4);
                }
                this.zzMt = zza.zzaY(string5 + string4);
            }
            string5 = zza.zzaY(string2 + string4);
            if (TextUtils.isEmpty((CharSequence)string5)) {
                return false;
            }
            if (string5.equals(this.zzMt)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzMt)) {
                this.zzba("Resetting the client id because Advertising Id changed.");
                string4 = this.zziz().zzju();
                this.zza("New client Id", string4);
            }
            return this.zzaZ(string2 + string4);
        }
    }

    protected AdvertisingIdClient.Info zzii() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo(this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzbd("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzMq) break block3;
                zzMq = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzaY(String string2) {
        MessageDigest messageDigest = zzam.zzbs("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    private boolean zzaZ(String string2) {
        try {
            String string3 = zza.zzaY(string2);
            this.zzba("Storing hashed adid.");
            Context context = this.getContext();
            FileOutputStream fileOutputStream = context.openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string3.getBytes());
            fileOutputStream.close();
            this.zzMt = string3;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    protected String zzij() {
        String string2 = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzbd("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzba("Hash file is empty.");
                fileInputStream.close();
            } else {
                string2 = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string2;
    }
}

