/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.analytics.internal.zzx;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

class zzj
extends zzd
implements Closeable {
    private static final String zzNm = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private static final String zzNn = String.format("SELECT MAX(%s) FROM %s WHERE 1;", "hit_time", "hits2");
    private final zza zzNo;
    private final zzaj zzNp = new zzaj(this.zzit());
    private final zzaj zzNq = new zzaj(this.zzit());

    zzj(zzf zzf2) {
        super(zzf2);
        String string2 = this.zziZ();
        this.zzNo = new zza(zzf2.getContext(), string2);
    }

    @Override
    protected void zzhR() {
    }

    public void beginTransaction() {
        this.zziE();
        this.getWritableDatabase().beginTransaction();
    }

    public void setTransactionSuccessful() {
        this.zziE();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    public void endTransaction() {
        this.zziE();
        this.getWritableDatabase().endTransaction();
    }

    public void zziU() {
        this.zzis();
        this.zziE();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("hits2", null, null);
    }

    public void zziV() {
        this.zzis();
        this.zziE();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("properties", null, null);
    }

    public void zzc(zzab zzab2) {
        com.google.android.gms.common.internal.zzx.zzw(zzab2);
        this.zzis();
        this.zziE();
        String string2 = zzj.zze(zzab2);
        if (string2.length() > 8192) {
            this.zziu().zza(zzab2, "Hit length exceeds the maximum allowed size");
            return;
        }
        this.zziY();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", string2);
        contentValues.put("hit_time", Long.valueOf(zzab2.zzkA()));
        contentValues.put("hit_app_id", Integer.valueOf(zzab2.zzky()));
        contentValues.put("hit_url", this.zzd(zzab2));
        try {
            long l2 = sQLiteDatabase.insert("hits2", null, contentValues);
            if (l2 == -1L) {
                this.zzbe("Failed to insert a hit (got -1)");
            } else {
                this.zzb("Hit saved to database. db-id, hit", l2, zzab2);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a hit", (Object)sQLiteException);
        }
    }

    public long zziP() {
        this.zzis();
        this.zziE();
        long l2 = this.zzb("SELECT COUNT(*) FROM hits2", null);
        return l2;
    }

    boolean isEmpty() {
        return this.zziP() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> zzo(long l2) {
        this.zzis();
        this.zziE();
        if (l2 <= 0L) {
            return Collections.emptyList();
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l2));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(cursor.getLong(0));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    public List<zzab> zzp(long l2) {
        com.google.android.gms.common.internal.zzx.zzaa(l2 >= 0L);
        this.zzis();
        this.zziE();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time", "hit_string", "hit_url", "hit_app_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l2));
            ArrayList<zzab> arrayList = new ArrayList<zzab>();
            if (cursor.moveToFirst()) {
                do {
                    long l3 = cursor.getLong(0);
                    long l4 = cursor.getLong(1);
                    String string2 = cursor.getString(2);
                    String string3 = cursor.getString(3);
                    int n = cursor.getInt(4);
                    Map<String, String> map = this.zzbf(string2);
                    boolean bl = zzam.zzbu(string3);
                    arrayList.add(new zzab(this, map, l4, bl, l3, n));
                } while (cursor.moveToNext());
            }
            ArrayList<zzab> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public void zzk(List<Long> list) {
        Long l2;
        com.google.android.gms.common.internal.zzx.zzw(list);
        this.zzis();
        this.zziE();
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("hit_id");
        stringBuilder.append(" in (");
        for (int i = 0; i < list.size(); ++i) {
            l2 = list.get(i);
            if (l2 == null || l2 == 0L) {
                throw new SQLiteException("Invalid hit id");
            }
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(l2);
        }
        stringBuilder.append(")");
        String string2 = stringBuilder.toString();
        try {
            l2 = this.getWritableDatabase();
            this.zza("Deleting dispatched hits. count", list.size());
            int n = l2.delete("hits2", string2, null);
            if (n != list.size()) {
                this.zzb("Deleted fewer hits then expected", list.size(), n, string2);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error deleting hits", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    public void zzq(long l2) {
        this.zzis();
        this.zziE();
        ArrayList<Long> arrayList = new ArrayList<Long>(1);
        arrayList.add(l2);
        this.zza("Deleting hit, id", l2);
        this.zzk(arrayList);
    }

    public int zziW() {
        this.zzis();
        this.zziE();
        if (!this.zzNp.zzv(86400000L)) {
            return 0;
        }
        this.zzNp.start();
        this.zzba("Deleting stale hits (if any)");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        long l2 = this.zzit().currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("hits2", "hit_time < ?", new String[]{Long.toString(l2)});
        this.zza("Deleted stale hits, count", n);
        return n;
    }

    public long zziX() {
        this.zzis();
        this.zziE();
        return this.zza(zzNn, null, 0L);
    }

    public void zza(long l2, String string2) {
        com.google.android.gms.common.internal.zzx.zzcr(string2);
        this.zziE();
        this.zzis();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l2), string2});
        if (n > 0) {
            this.zza("Deleted property records", n);
        }
    }

    public void zzb(zzh zzh2) {
        com.google.android.gms.common.internal.zzx.zzw(zzh2);
        this.zziE();
        this.zzis();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String string2 = zzj.zzB(zzh2.zzn());
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_uid", Long.valueOf(zzh2.zziM()));
        contentValues.put("cid", zzh2.getClientId());
        contentValues.put("tid", zzh2.zziN());
        contentValues.put("adid", Integer.valueOf(zzh2.zziO() ? 1 : 0));
        contentValues.put("hits_count", Long.valueOf(zzh2.zziP()));
        contentValues.put("params", string2);
        try {
            long l2 = sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5);
            if (l2 == -1L) {
                this.zzbe("Failed to insert/update a property (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a property", (Object)sQLiteException);
        }
    }

    public long zza(long l2, String string2, String string3) {
        com.google.android.gms.common.internal.zzx.zzcr(string2);
        com.google.android.gms.common.internal.zzx.zzcr(string3);
        this.zziE();
        this.zzis();
        long l3 = this.zza("SELECT hits_count FROM properties WHERE app_uid=? AND cid=? AND tid=?", new String[]{String.valueOf(l2), string2, string3}, 0L);
        return l3;
    }

    public List<zzh> zzr(long l2) {
        this.zziE();
        this.zzis();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            Object object;
            String[] stringArray = new String[]{"cid", "tid", "adid", "hits_count", "params"};
            int n = this.zziv().zzjZ();
            String string2 = String.valueOf(n);
            String string3 = "app_uid=?";
            String[] stringArray2 = new String[]{String.valueOf(l2)};
            cursor = sQLiteDatabase.query("properties", stringArray, string3, stringArray2, null, null, null, string2);
            ArrayList<zzh> arrayList = new ArrayList<zzh>();
            if (cursor.moveToFirst()) {
                do {
                    object = cursor.getString(0);
                    String string4 = cursor.getString(1);
                    boolean bl = cursor.getInt(2) != 0;
                    long l3 = cursor.getInt(3);
                    String string5 = cursor.getString(4);
                    Map<String, String> map = this.zzbg(string5);
                    if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)string4)) {
                        this.zzc("Read property with empty client id or tracker id", object, string4);
                        continue;
                    }
                    zzh zzh2 = new zzh(l2, (String)object, string4, bl, l3, map);
                    arrayList.add(zzh2);
                } while (cursor.moveToNext());
            }
            if (arrayList.size() >= n) {
                this.zzbd("Sending hits to too many properties. Campaign report might be incorrect");
            }
            object = arrayList;
            return object;
        }
    }

    @Override
    public void close() {
        try {
            this.zzNo.close();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Sql error closing database", (Object)sQLiteException);
        }
        catch (IllegalStateException illegalStateException) {
            this.zze("Error closing database", illegalStateException);
        }
    }

    private String zzd(zzab zzab2) {
        if (zzab2.zzkC()) {
            return this.zziv().zzjO();
        }
        return this.zziv().zzjP();
    }

    private long zzb(String string2, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string2, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Database error", string2, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    private long zza(String string2, String[] stringArray, long l2) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string2, stringArray);
            if (cursor.moveToFirst()) {
                long l3 = cursor.getLong(0);
                return l3;
            }
            long l4 = l2;
            return l4;
        }
    }

    private void zziY() {
        int n = this.zziv().zzjY();
        long l2 = this.zziP();
        if (l2 > (long)(n - 1)) {
            long l3 = l2 - (long)n + 1L;
            List<Long> list = this.zzo(l3);
            this.zzd("Store full, deleting hits to make room, count", list.size());
            this.zzk(list);
        }
    }

    private static String zze(zzab zzab2) {
        com.google.android.gms.common.internal.zzx.zzw(zzab2);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object2 : zzab2.zzn().entrySet()) {
            String string2 = object2.getKey();
            if ("ht".equals(string2) || "qt".equals(string2) || "AppUID".equals(string2)) continue;
            builder.appendQueryParameter(string2, object2.getValue());
        }
        Uri uri = builder.build();
        String string3 = uri.getEncodedQuery();
        if (string3 == null) {
            return "";
        }
        return string3;
    }

    private static String zzB(Map<String, String> map) {
        com.google.android.gms.common.internal.zzx.zzw(map);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            String string2 = object2.getKey();
            builder.appendQueryParameter(string2, object2.getValue());
        }
        Uri uri = builder.build();
        String string3 = uri.getEncodedQuery();
        if (string3 == null) {
            return "";
        }
        return string3;
    }

    Map<String, String> zzbf(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string3 = string2.startsWith("?") ? string2 : "?" + string2;
            List list = URLEncodedUtils.parse((URI)new URI(string3), (String)"UTF-8");
            HashMap<String, String> hashMap = new HashMap<String, String>(list.size());
            for (NameValuePair nameValuePair : list) {
                hashMap.put(nameValuePair.getName(), nameValuePair.getValue());
            }
            return hashMap;
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing hit parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    Map<String, String> zzbg(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string3 = "?" + string2;
            List list = URLEncodedUtils.parse((URI)new URI(string3), (String)"UTF-8");
            HashMap<String, String> hashMap = new HashMap<String, String>(list.size());
            for (NameValuePair nameValuePair : list) {
                hashMap.put(nameValuePair.getName(), nameValuePair.getValue());
            }
            return hashMap;
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing property parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    SQLiteDatabase getWritableDatabase() {
        try {
            return this.zzNo.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    private String zziZ() {
        if (!this.zziv().zzjA()) {
            return this.zziv().zzka();
        }
        if (this.zziv().zzjB()) {
            return this.zziv().zzka();
        }
        return this.zziv().zzkb();
    }

    class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string2) {
            super(context, string2, null, 1);
        }

        public SQLiteDatabase getWritableDatabase() {
            if (!zzj.this.zzNq.zzv(3600000L)) {
                throw new SQLiteException("Database open failed");
            }
            try {
                SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                return sQLiteDatabase;
            }
            catch (SQLiteException sQLiteException) {
                zzj.this.zzNq.start();
                zzj.this.zzbe("Opening the database failed, dropping the table and recreating it");
                String string2 = zzj.this.zziZ();
                zzj.this.getContext().getDatabasePath(string2).delete();
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zzj.this.zzNq.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zzj.this.zze("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(SQLiteDatabase sQLiteDatabase, String string2) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string2}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string2) {
            HashSet<String> hashSet = new HashSet<String>();
            String string3 = "SELECT * FROM " + string2 + " LIMIT 0";
            try (Cursor cursor = sQLiteDatabase.rawQuery(string3, null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            return hashSet;
        }

        private void zza(SQLiteDatabase sQLiteDatabase) {
            boolean bl;
            String[] stringArray;
            Set<String> set = this.zzb(sQLiteDatabase, "hits2");
            for (String string2 : stringArray = new String[]{"hit_id", "hit_string", "hit_time", "hit_url"}) {
                if (set.remove(string2)) continue;
                throw new SQLiteException("Database hits2 is missing required column: " + string2);
            }
            boolean bl2 = bl = !set.remove("hit_app_id");
            if (!set.isEmpty()) {
                throw new SQLiteException("Database hits2 has extra columns");
            }
            if (bl) {
                String string3 = "ALTER TABLE hits2 ADD COLUMN hit_app_id INTEGER";
                sQLiteDatabase.execSQL(string3);
            }
        }

        private void zzb(SQLiteDatabase sQLiteDatabase) {
            String[] stringArray;
            Set<String> set = this.zzb(sQLiteDatabase, "properties");
            for (String string2 : stringArray = new String[]{"app_uid", "cid", "tid", "params", "adid", "hits_count"}) {
                if (set.remove(string2)) continue;
                throw new SQLiteException("Database properties is missing required column: " + string2);
            }
            if (!set.isEmpty()) {
                throw new SQLiteException("Database properties table has extra columns");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase database) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = database.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza(database, "hits2")) {
                database.execSQL(zzNm);
            } else {
                this.zza(database);
            }
            if (!this.zza(database, "properties")) {
                database.execSQL("CREATE TABLE IF NOT EXISTS properties ( app_uid INTEGER NOT NULL, cid TEXT NOT NULL, tid TEXT NOT NULL, params TEXT NOT NULL, adid INTEGER NOT NULL, hits_count INTEGER NOT NULL, PRIMARY KEY (app_uid, cid, tid)) ;");
            } else {
                this.zzb(database);
            }
        }

        public void onCreate(SQLiteDatabase database) {
            zzx.zzbl(database.getPath());
        }

        public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        }
    }
}

