/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.AnalyticsReceiver;
import com.google.android.gms.analytics.AnalyticsService;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzag;
import com.google.android.gms.analytics.internal.zzah;
import com.google.android.gms.analytics.internal.zzai;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzg;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.analytics.internal.zzi;
import com.google.android.gms.analytics.internal.zzj;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.analytics.internal.zzv;
import com.google.android.gms.analytics.internal.zzw;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpc;
import com.google.android.gms.measurement.zzc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class zzl
extends zzd {
    private boolean mStarted;
    private final zzj zzNt;
    private final zzah zzNu;
    private final zzag zzNv;
    private final zzi zzNw;
    private long zzNx;
    private final zzt zzNy;
    private final zzt zzNz;
    private final zzaj zzNA;
    private long zzNB;
    private boolean zzNC;

    protected zzl(zzf zzf2, zzg zzg2) {
        super(zzf2);
        zzx.zzw(zzg2);
        this.zzNx = Long.MIN_VALUE;
        this.zzNv = zzg2.zzk(zzf2);
        this.zzNt = zzg2.zzm(zzf2);
        this.zzNu = zzg2.zzn(zzf2);
        this.zzNw = zzg2.zzo(zzf2);
        this.zzNA = new zzaj(this.zzit());
        this.zzNy = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zzje();
            }
        };
        this.zzNz = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zzjf();
            }
        };
    }

    @Override
    protected void zzhR() {
        this.zzNt.zza();
        this.zzNu.zza();
        this.zzNw.zza();
    }

    void start() {
        this.zziE();
        zzx.zza(!this.mStarted, (Object)"Analytics backend already started");
        this.mStarted = true;
        if (!this.zziv().zzjA()) {
            this.zzjc();
        }
        this.zziw().zzg(new Runnable(){

            @Override
            public void run() {
                zzl.this.zzjd();
            }
        });
    }

    private void zzjc() {
        boolean bl;
        zzf zzf2 = this.zziq();
        Context context = zzf2.getContext();
        boolean bl2 = AnalyticsReceiver.zzV(context);
        if (!bl2) {
            this.zzbd("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            bl = AnalyticsService.zzW(context);
            if (!bl) {
                this.zzbe("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
        bl = CampaignTrackingReceiver.zzV(context);
        if (!bl) {
            this.zzbd("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            boolean bl3 = CampaignTrackingService.zzW(context);
            if (!bl3) {
                this.zzbd("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
    }

    private boolean zzbh(String string2) {
        int n = this.getContext().checkCallingOrSelfPermission(string2);
        return n == 0;
    }

    protected void zzjd() {
        this.zziE();
        this.zziy().zzkO();
        if (!this.zzbh("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzbe("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzjs();
        }
        if (!this.zzbh("android.permission.INTERNET")) {
            this.zzbe("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzjs();
        }
        if (AnalyticsService.zzW(this.getContext())) {
            this.zzba("AnalyticsService registered in the app manifest and enabled");
        } else if (this.zziv().zzjA()) {
            this.zzbe("Device AnalyticsService not registered! Hits will not be delivered reliably.");
        } else {
            this.zzbd("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!(this.zzNC || this.zziv().zzjA() || this.zzNt.isEmpty())) {
            this.zzjg();
        }
        this.zzjk();
    }

    private void zzje() {
        this.zzb(new zzw(){

            @Override
            public void zzc(Throwable throwable) {
                zzl.this.zzjk();
            }
        });
    }

    void zzip() {
        this.zzis();
        this.zzNB = this.zzit().currentTimeMillis();
    }

    protected void onServiceConnected() {
        this.zzis();
        if (!this.zziv().zzjA()) {
            this.zzjh();
        }
    }

    public void zzin() {
        com.google.android.gms.measurement.zzg.zzis();
        this.zziE();
        this.zzba("Service disconnected");
    }

    public void zzI(boolean bl) {
        this.zzjk();
    }

    private void zzjf() {
        try {
            this.zzNt.zziW();
            this.zzjk();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzNz.zzt(this.zziv().zzkc());
    }

    protected void zzc(zzh zzh2) {
        this.zzis();
        this.zzb("Sending first hit to property", zzh2.zziN());
        if (this.zziy().zzkP().zzv(this.zziv().zzkf())) {
            return;
        }
        String string2 = this.zziy().zzkS();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        zzpc zzpc2 = zzam.zza(this.zziu(), string2);
        this.zzb("Found relevant installation campaign", zzpc2);
        this.zza(zzh2, zzpc2);
    }

    public void zzs(long l2) {
        com.google.android.gms.measurement.zzg.zzis();
        this.zziE();
        if (l2 < 0L) {
            l2 = 0L;
        }
        this.zzNx = l2;
        this.zzjk();
    }

    protected void zzjg() {
        if (this.zzNC) {
            return;
        }
        if (!this.zziv().zzjC()) {
            return;
        }
        if (this.zzNw.isConnected()) {
            return;
        }
        long l2 = this.zziv().zzjX();
        if (this.zzNA.zzv(l2)) {
            this.zzNA.start();
            this.zzba("Connecting to service");
            if (this.zzNw.connect()) {
                this.zzba("Connected to service");
                this.zzNA.clear();
                this.onServiceConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zza(zzh zzh2, boolean bl) {
        zzx.zzw(zzh2);
        this.zziE();
        this.zzis();
        long l2 = -1L;
        try {
            this.zzNt.beginTransaction();
            this.zzNt.zza(zzh2.zziM(), zzh2.getClientId());
            l2 = this.zzNt.zza(zzh2.zziM(), zzh2.getClientId(), zzh2.zziN());
            if (!bl) {
                zzh2.zzn(l2);
            } else {
                zzh2.zzn(l2 + 1L);
            }
            this.zzNt.zzb(zzh2);
            this.zzNt.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            long l3 = -1L;
            return l3;
        }
        finally {
            try {
                this.zzNt.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l2;
    }

    public void zza(zzab zzab2) {
        zzx.zzw(zzab2);
        com.google.android.gms.measurement.zzg.zzis();
        this.zziE();
        if (this.zzNC) {
            this.zzbb("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzab2);
        }
        zzab2 = this.zzf(zzab2);
        this.zzjg();
        if (this.zzNw.zzb(zzab2)) {
            this.zzbb("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        if (this.zziv().zzjA()) {
            this.zziu().zza(zzab2, "Service unavailable on package side");
            return;
        }
        try {
            this.zzNt.zzc(zzab2);
            this.zzjk();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zziu().zza(zzab2, "deliver: failed to insert hit to database");
        }
    }

    public void zzik() {
        com.google.android.gms.measurement.zzg.zzis();
        this.zziE();
        if (!this.zziv().zzjA()) {
            this.zzba("Delete all hits from local store");
            try {
                this.zzNt.zziU();
                this.zzNt.zziV();
                this.zzjk();
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Failed to delete hits from store", (Object)sQLiteException);
            }
        }
        this.zzjg();
        if (this.zzNw.zziQ()) {
            this.zzba("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    zzab zzf(zzab zzab2) {
        if (!TextUtils.isEmpty((CharSequence)zzab2.zzkE())) {
            return zzab2;
        }
        zzai.zza zza2 = this.zziy().zzkT();
        Pair<String, Long> pair = zza2.zzkW();
        if (pair == null) {
            return zzab2;
        }
        Long l2 = (Long)pair.second;
        String string2 = (String)pair.first;
        String string3 = l2 + ":" + string2;
        HashMap<String, String> hashMap = new HashMap<String, String>(zzab2.zzn());
        hashMap.put("_m", string3);
        return zzab.zza(this, zzab2, hashMap);
    }

    public void zzjh() {
        com.google.android.gms.measurement.zzg.zzis();
        this.zziE();
        this.zzir();
        if (!this.zziv().zzjC()) {
            this.zzbd("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!this.zzNw.isConnected()) {
            this.zzba("Service not connected");
            return;
        }
        if (this.zzNt.isEmpty()) {
            return;
        }
        this.zzba("Dispatching local hits to device AnalyticsService");
        block4: while (true) {
            List<zzab> list;
            try {
                list = this.zzNt.zzp(this.zziv().zzjL());
                if (list.isEmpty()) {
                    this.zzjk();
                    return;
                }
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to read hits from store", (Object)sQLiteException);
                this.zzjo();
                return;
            }
            while (true) {
                if (list.isEmpty()) continue block4;
                zzab zzab2 = list.get(0);
                if (!this.zzNw.zzb(zzab2)) {
                    this.zzjk();
                    return;
                }
                list.remove(zzab2);
                try {
                    this.zzNt.zzq(zzab2.zzkz());
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                    this.zzjo();
                    return;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean zzji() {
        boolean bl;
        com.google.android.gms.measurement.zzg.zzis();
        this.zziE();
        this.zzba("Dispatching a batch of local hits");
        boolean bl2 = !this.zzNw.isConnected() && !this.zziv().zzjA();
        boolean bl3 = bl = !this.zzNu.zzkK();
        if (bl2 && bl) {
            this.zzba("No network or service available. Will retry later");
            return false;
        }
        long l2 = Math.max(this.zziv().zzjL(), this.zziv().zzjM());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l3 = 0L;
        while (true) {
            try {
                Object object;
                List<zzab> list;
                block38: {
                    this.zzNt.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzNt.zzp(l2);
                        if (!list.isEmpty()) break block38;
                        this.zzba("Store is empty, nothing to dispatch");
                        this.zzjo();
                        boolean bl4 = false;
                        return bl4;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzjo();
                        boolean bl5 = false;
                        try {
                            this.zzNt.setTransactionSuccessful();
                            this.zzNt.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzjo();
                            return false;
                        }
                        return bl5;
                    }
                }
                this.zza("Hits loaded from store. count", (Object)list.size());
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((zzab)object).zzkz() != l3) continue;
                    this.zzd("Database contains successfully uploaded hit", l3, list.size());
                    this.zzjo();
                    boolean bl6 = false;
                    return bl6;
                }
                if (this.zzNw.isConnected() && !this.zziv().zzjA()) {
                    this.zzba("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzNw.zzb((zzab)(object2 = list.get(0)))) {
                        l3 = Math.max(l3, ((zzab)object2).zzkz());
                        list.remove(object2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", object2);
                        try {
                            this.zzNt.zzq(((zzab)object2).zzkz());
                            arrayList.add(((zzab)object2).zzkz());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzjo();
                            boolean bl7 = false;
                            try {
                                this.zzNt.setTransactionSuccessful();
                                this.zzNt.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzjo();
                                return false;
                            }
                            return bl7;
                        }
                    }
                }
                if (this.zzNu.zzkK()) {
                    object2 = this.zzNu.zzm(list);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Long l4 = (Long)object.next();
                        l3 = Math.max(l3, l4);
                    }
                    list.removeAll((Collection<?>)object2);
                    try {
                        this.zzNt.zzk((List<Long>)object2);
                        arrayList.addAll((Collection<Long>)object2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzjo();
                        boolean bl8 = false;
                        try {
                            this.zzNt.setTransactionSuccessful();
                            this.zzNt.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzjo();
                            return false;
                        }
                        return bl8;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                boolean bl9 = false;
                return bl9;
            }
            finally {
                try {
                    this.zzNt.setTransactionSuccessful();
                    this.zzNt.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzjo();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public void zzb(zzw zzw2) {
        this.zza(zzw2, this.zzNB);
    }

    public void zza(final zzw zzw2, final long l2) {
        block8: {
            com.google.android.gms.measurement.zzg.zzis();
            this.zziE();
            long l3 = -1L;
            long l4 = this.zziy().zzkQ();
            if (l4 != 0L) {
                l3 = Math.abs(this.zzit().currentTimeMillis() - l4);
            }
            this.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l3);
            if (!this.zziv().zzjA()) {
                this.zzjg();
            }
            try {
                boolean bl = this.zzji();
                if (bl) {
                    this.zziw().zzg(new Runnable(){

                        @Override
                        public void run() {
                            zzl.this.zza(zzw2, l2);
                        }
                    });
                } else {
                    this.zziy().zzkR();
                    this.zzjk();
                    if (zzw2 != null) {
                        zzw2.zzc(null);
                    }
                    if (this.zzNB != l2) {
                        this.zzNv.zzkJ();
                    }
                }
            }
            catch (Throwable throwable) {
                this.zze("Local dispatch failed", throwable);
                this.zziy().zzkR();
                this.zzjk();
                if (zzw2 == null) break block8;
                zzw2.zzc(throwable);
            }
        }
    }

    public void zzjj() {
        com.google.android.gms.measurement.zzg.zzis();
        this.zziE();
        this.zzbb("Sync dispatching local hits");
        long l2 = this.zzNB;
        if (!this.zziv().zzjA()) {
            this.zzjg();
        }
        try {
            while (this.zzji()) {
            }
            this.zziy().zzkR();
            this.zzjk();
            if (this.zzNB != l2) {
                this.zzNv.zzkJ();
            }
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzjk();
        }
    }

    public long zziX() {
        com.google.android.gms.measurement.zzg.zzis();
        this.zziE();
        try {
            return this.zzNt.zziX();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public void zzjk() {
        boolean bl;
        this.zziq().zzis();
        this.zziE();
        if (!this.zzjl()) {
            this.zzNv.unregister();
            this.zzjo();
            return;
        }
        if (this.zzNt.isEmpty()) {
            this.zzNv.unregister();
            this.zzjo();
            return;
        }
        if (!zzy.zzON.get().booleanValue()) {
            this.zzNv.zzkH();
            bl = this.zzNv.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            this.zzjn();
        } else {
            this.zzjo();
            this.zzjm();
        }
    }

    private boolean zzjl() {
        if (this.zzNC) {
            return false;
        }
        if (this.zziv().zzjA() && !this.zziv().zzjB()) {
            return false;
        }
        return this.zzjr() > 0L;
    }

    private void zzjm() {
        long l2;
        long l3;
        long l4;
        zzv zzv2 = this.zzix();
        if (!zzv2.zzkk()) {
            return;
        }
        if (!zzv2.zzbp() && (l4 = this.zziX()) != 0L && (l3 = Math.abs((l2 = this.zzit().currentTimeMillis()) - l4)) <= this.zziv().zzjK()) {
            long l5 = this.zziv().zzjJ();
            this.zza("Dispatch alarm scheduled (ms)", (Object)l5);
            zzv2.zzkl();
        }
    }

    private void zzjn() {
        long l2;
        long l3;
        this.zzjm();
        long l4 = this.zzjr();
        long l5 = this.zziy().zzkQ();
        long l6 = l5 != 0L ? ((l3 = l4 - (l2 = Math.abs(this.zzit().currentTimeMillis() - l5))) > 0L ? l3 : Math.min(this.zziv().zzjH(), l4)) : Math.min(this.zziv().zzjH(), l4);
        this.zza("Dispatch scheduled (ms)", (Object)l6);
        if (this.zzNy.zzbp()) {
            l2 = Math.max(1L, l6 + this.zzNy.zzkh());
            this.zzNy.zzu(l2);
        } else {
            this.zzNy.zzt(l6);
        }
    }

    private void zzjo() {
        this.zzjp();
        this.zzjq();
    }

    private void zzjp() {
        if (this.zzNy.zzbp()) {
            this.zzba("All hits dispatched or no network/service. Going to power save mode");
        }
        this.zzNy.cancel();
    }

    private void zzjq() {
        zzv zzv2 = this.zzix();
        if (zzv2.zzbp()) {
            zzv2.cancel();
        }
    }

    public long zzjr() {
        if (this.zzNx != Long.MIN_VALUE) {
            return this.zzNx;
        }
        long l2 = this.zziv().zzjI();
        if (this.zzhQ().zzku()) {
            l2 = (long)this.zzhQ().zzll() * 1000L;
        }
        return l2;
    }

    public void zzbi(String string2) {
        zzx.zzcr(string2);
        this.zzis();
        this.zzir();
        zzpc zzpc2 = zzam.zza(this.zziu(), string2);
        if (zzpc2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string2);
            return;
        }
        String string3 = this.zziy().zzkS();
        if (string2.equals(string3)) {
            this.zzbd("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string3, string2);
            return;
        }
        this.zziy().zzbm(string2);
        if (this.zziy().zzkP().zzv(this.zziv().zzkf())) {
            this.zzd("Campaign received too late, ignoring", zzpc2);
            return;
        }
        this.zzb("Received installation campaign", zzpc2);
        List<zzh> list = this.zzNt.zzr(0L);
        for (zzh zzh2 : list) {
            this.zza(zzh2, zzpc2);
        }
    }

    private void zza(zzh zzh2, zzpc zzpc2) {
        zzx.zzw(zzh2);
        zzx.zzw(zzpc2);
        zza zza2 = new zza(this.zziq());
        zza2.zzaP(zzh2.zziN());
        zza2.enableAdvertisingIdCollection(zzh2.zziO());
        zzc zzc2 = zza2.zzhG();
        zzjo zzjo2 = zzc2.zze(zzjo.class);
        zzjo2.zzaU("data");
        zzjo2.zzH(true);
        zzc2.zzb(zzpc2);
        zzjn zzjn2 = zzc2.zze(zzjn.class);
        zzpb zzpb2 = zzc2.zze(zzpb.class);
        for (Map.Entry<String, String> entry : zzh2.zzn().entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if ("an".equals(string2)) {
                zzpb2.setAppName(string3);
                continue;
            }
            if ("av".equals(string2)) {
                zzpb2.setAppVersion(string3);
                continue;
            }
            if ("aid".equals(string2)) {
                zzpb2.setAppId(string3);
                continue;
            }
            if ("aiid".equals(string2)) {
                zzpb2.setAppInstallerId(string3);
                continue;
            }
            if ("uid".equals(string2)) {
                zzjo2.setUserId(string3);
                continue;
            }
            zzjn2.set(string2, string3);
        }
        this.zzb("Sending installation campaign to", zzh2.zziN(), zzpc2);
        zzc2.zzL(this.zziy().zzkO());
        zzc2.zzyi();
    }

    public void zzjs() {
        this.zziE();
        this.zzis();
        this.zzNC = true;
        this.zzNw.disconnect();
        this.zzjk();
    }
}

