/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzn
extends zzd {
    private volatile String zzMj;
    private Future<String> zzNM;

    protected zzn(zzf zzf2) {
        super(zzf2);
    }

    @Override
    protected void zzhR() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzjt() {
        this.zziE();
        zzn zzn2 = this;
        synchronized (zzn2) {
            if (this.zzMj == null) {
                this.zzNM = this.zziw().zzb(new Callable<String>(){

                    public String zzjy() throws Exception {
                        return zzn.this.zzjv();
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.zzjy();
                    }
                });
            }
            if (this.zzNM != null) {
                try {
                    this.zzMj = this.zzNM.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzMj = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzMj = "0";
                }
                if (this.zzMj == null) {
                    this.zzMj = "0";
                }
                this.zza("Loaded clientId", this.zzMj);
                this.zzNM = null;
            }
            return this.zzMj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String zzju() {
        zzn zzn2 = this;
        synchronized (zzn2) {
            this.zzMj = null;
            this.zzNM = this.zziw().zzb(new Callable<String>(){

                public String zzjy() throws Exception {
                    return zzn.this.zzjw();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.zzjy();
                }
            });
        }
        return this.zzjt();
    }

    String zzjv() {
        String string2 = this.zzZ(this.zziw().getContext());
        if (string2 == null) {
            string2 = this.zzjw();
        }
        return string2;
    }

    private String zzjw() {
        String string2 = this.zzjx();
        try {
            if (!this.zzi(this.zziw().getContext(), string2)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string2;
    }

    protected String zzjx() {
        return UUID.randomUUID().toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String zzZ(Context context) {
        zzx.zzcj("ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, byArray.length);
            if (fileInputStream.available() > 0) {
                this.zzbd("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                String string2 = null;
                return string2;
            }
            if (n < 14) {
                this.zzbd("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                String string3 = null;
                return string3;
            }
            fileInputStream.close();
            String string4 = new String(byArray, 0, n);
            this.zza("Read client id from disk", string4);
            String string5 = string4;
            return string5;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string6 = null;
            return string6;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            String string7 = null;
            return string7;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzi(Context context, String string2) {
        zzx.zzcr(string2);
        zzx.zzcj("ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string2);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string2.getBytes());
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }
}

