/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzl zzVo = new zzl("CastRemoteDisplayLocalService");
    private static final int zzVp = R.id.cast_notification_id;
    private static final Object zzVq = new Object();
    private static AtomicBoolean zzVr = new AtomicBoolean(false);
    private GoogleApiClient zzVs;
    private CastRemoteDisplay.CastRemoteDisplaySessionCallbacks zzVt;
    private String zzUM;
    private Callbacks zzVu;
    private zzb zzVv;
    private NotificationSettings zzVw;
    private Notification mNotification;
    private Boolean zzVx;
    private PendingIntent zzVy;
    private CastDevice zzVz;
    private Display zzVA;
    private Context zzVB;
    private ServiceConnection zzVC;
    private Handler mHandler;
    private MediaRouter zzVD;
    private final MediaRouter.Callback zzVE = new MediaRouter.Callback(){

        public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo info) {
            CastRemoteDisplayLocalService.this.zzbb("onRouteUnselected");
            if (CastRemoteDisplayLocalService.this.zzVz == null) {
                CastRemoteDisplayLocalService.this.zzbb("onRouteUnselected, no device was selected");
                return;
            }
            CastDevice castDevice = CastDevice.getFromBundle(info.getExtras());
            if (!castDevice.getDeviceId().equals(CastRemoteDisplayLocalService.this.zzVz.getDeviceId())) {
                CastRemoteDisplayLocalService.this.zzbb("onRouteUnselected, device does not match");
                return;
            }
            CastRemoteDisplayLocalService.stopService();
        }
    };
    private static CastRemoteDisplayLocalService zzVF;
    private final IBinder zzVG = new zza();

    public IBinder onBind(Intent intent) {
        this.zzbb("onBind");
        return this.zzVG;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.zzbb("onStartCommand");
        return 2;
    }

    protected static void setDebugEnabled() {
        zzVo.zzX(true);
    }

    protected Display getDisplay() {
        return this.zzVA;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzVq;
        synchronized (object) {
            return zzVF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startService(final Context activityContext, Class<? extends CastRemoteDisplayLocalService> serviceClass, final String applicationId, final CastDevice device, final NotificationSettings notificationSettings, final Callbacks callbacks) {
        zzVo.zzb("Starting Service", new Object[0]);
        Object object = zzVq;
        synchronized (object) {
            if (zzVF != null) {
                zzVo.zzf("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzR(true);
            }
        }
        CastRemoteDisplayLocalService.zzb(activityContext, serviceClass);
        zzx.zzb(activityContext, (Object)"activityContext is required.");
        zzx.zzb(serviceClass, (Object)"serviceClass is required.");
        zzx.zzb(applicationId, (Object)"applicationId is required.");
        zzx.zzb(device, (Object)"device is required.");
        zzx.zzb(notificationSettings, (Object)"notificationSettings is required.");
        zzx.zzb(callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.zzVN == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzVr.getAndSet(true)) {
            zzVo.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(activityContext, serviceClass);
        activityContext.startService((Intent)object);
        activityContext.bindService((Intent)object, new ServiceConnection(){

            public void onServiceConnected(ComponentName className, IBinder binder) {
                CastRemoteDisplayLocalService castRemoteDisplayLocalService = ((zza)binder).zzmw();
                if (castRemoteDisplayLocalService == null || !castRemoteDisplayLocalService.zza(applicationId, device, notificationSettings, activityContext, this, callbacks)) {
                    zzVo.zzc("Connected but unable to get the service instance", new Object[0]);
                    callbacks.onRemoteDisplaySessionError(new Status(2200));
                    zzVr.set(false);
                    try {
                        activityContext.unbindService((ServiceConnection)this);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzVo.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                }
            }

            public void onServiceDisconnected(ComponentName arg0) {
                zzVo.zzb("onServiceDisconnected", new Object[0]);
                callbacks.onRemoteDisplaySessionError(new Status(2201, "Service Disconnected"));
                zzVr.set(false);
                try {
                    activityContext.unbindService((ServiceConnection)this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    zzVo.zzb("No need to unbind service, already unbound", new Object[0]);
                }
            }
        }, 64);
    }

    private void zzQ(boolean bl) {
        this.zzbb("Stopping Service");
        if (!bl && this.zzVD != null) {
            this.zzbb("Setting default route");
            this.zzVD.selectRoute(this.zzVD.getDefaultRoute());
        }
        if (this.zzVv != null) {
            this.zzbb("Unregistering notification receiver");
            this.unregisterReceiver(this.zzVv);
        }
        this.zzmp();
        this.zzmq();
        this.zzml();
        if (this.zzVs != null) {
            this.zzVs.disconnect();
            this.zzVs = null;
        }
        if (this.zzVB != null && this.zzVC != null) {
            try {
                this.zzVB.unbindService(this.zzVC);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzbb("No need to unbind service, already unbound");
            }
            this.zzVC = null;
            this.zzVB = null;
        }
        this.zzUM = null;
        this.zzVs = null;
        this.mNotification = null;
        this.zzVA = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzR(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zzVo.zzb("Stopping Service", new Object[0]);
        zzVr.set(false);
        Object object = zzVq;
        synchronized (object) {
            if (zzVF == null) {
                zzVo.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzVF;
            zzVF = null;
        }
        castRemoteDisplayLocalService.zzQ(bl);
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzR(false);
    }

    public void updateNotificationSettings(NotificationSettings notificationSettings) {
        zzx.zzb(notificationSettings, (Object)"notificationSettings is required.");
        if (this.zzVw == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.zzVx.booleanValue()) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzVN != null) {
                this.zzVw.zzVN = notificationSettings.zzVN;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzVO)) {
                this.zzVw.zzVO = notificationSettings.zzVO;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzVP)) {
                this.zzVw.zzVP = notificationSettings.zzVP;
            }
            this.mNotification = this.zzS(true);
        } else {
            zzx.zzb(notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.zzVw.mNotification = this.mNotification;
        }
        this.startForeground(zzVp, this.mNotification);
    }

    public void onCreate() {
        super.onCreate();
        this.zzVt = new CastRemoteDisplay.CastRemoteDisplaySessionCallbacks(){

            @Override
            public void onRemoteDisplayEnded(Status status) {
                zzVo.zzb(String.format("Cast screen has ended: %d", status.getStatusCode()), new Object[0]);
                if (CastRemoteDisplayLocalService.this.mHandler != null) {
                    CastRemoteDisplayLocalService.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CastRemoteDisplayLocalService.zzR(false);
                        }
                    });
                }
            }
        };
    }

    private static void zzb(Context context, Class clazz) {
        try {
            ComponentName componentName = new ComponentName(context, clazz);
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
    }

    private void zza(Display display) {
        this.zzVA = display;
        if (this.zzVx.booleanValue()) {
            this.mNotification = this.zzS(true);
            this.startForeground(zzVp, this.mNotification);
        }
        if (this.zzVu != null) {
            this.zzVu.onRemoteDisplaySessionStarted(this);
            this.zzVu = null;
        }
        this.onCreatePresentation(this.zzVA);
    }

    private void zzml() {
        if (this.zzVD != null) {
            zzx.zzci("CastRemoteDisplayLocalService calls must be done on the main thread");
            this.zzbb("removeMediaRouterCallback");
            this.zzVD.removeCallback(this.zzVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(String string2, CastDevice castDevice, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zzbb("startRemoteDisplaySession");
        zzx.zzci("Starting the Cast Remote Display must be done on the main thread");
        Object object = zzVq;
        synchronized (object) {
            if (zzVF != null) {
                zzVo.zzf("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            zzVF = this;
        }
        this.zzVu = callbacks;
        this.zzUM = string2;
        this.zzVz = castDevice;
        this.zzVB = context;
        this.zzVC = serviceConnection;
        this.zzVD = MediaRouter.getInstance((Context)this.getApplicationContext());
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zzUM)).build();
        this.zzbb("addMediaRouterCallback");
        this.zzVD.addCallback((MediaRouteSelector)object, this.zzVE, 4);
        this.mHandler = new Handler(this.getMainLooper());
        this.mNotification = notificationSettings.mNotification;
        this.zzVv = new zzb();
        this.registerReceiver(this.zzVv, new IntentFilter("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT"));
        this.zzVw = new NotificationSettings(notificationSettings);
        if (this.zzVw.mNotification == null) {
            this.zzVx = true;
            this.mNotification = this.zzS(false);
        } else {
            this.zzVx = false;
            this.mNotification = this.zzVw.mNotification;
        }
        this.startForeground(zzVp, this.mNotification);
        this.zzVs = this.zza(castDevice);
        this.zzVs.connect();
        return true;
    }

    private void zzmm() {
        this.zzbb("startRemoteDisplay");
        if (this.zzVs == null || !this.zzVs.isConnected()) {
            zzVo.zzc("Unable to start the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.startRemoteDisplay(this.zzVs, this.zzUM).setResultCallback(new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    zzVo.zzc("Connection was not successful", new Object[0]);
                    CastRemoteDisplayLocalService.this.zzmo();
                    return;
                }
                zzVo.zzb("startRemoteDisplay successful", new Object[0]);
                Object object = zzVq;
                synchronized (object) {
                    if (zzVF == null) {
                        zzVo.zzb("Remote Display started but session already cancelled", new Object[0]);
                        CastRemoteDisplayLocalService.this.zzmo();
                        return;
                    }
                }
                object = castRemoteDisplaySessionResult.getPresentationDisplay();
                if (object != null) {
                    CastRemoteDisplayLocalService.this.zza((Display)object);
                } else {
                    zzVo.zzc("Cast Remote Display session created without display", new Object[0]);
                }
                zzVr.set(false);
                if (CastRemoteDisplayLocalService.this.zzVB != null && CastRemoteDisplayLocalService.this.zzVC != null) {
                    try {
                        CastRemoteDisplayLocalService.this.zzVB.unbindService(CastRemoteDisplayLocalService.this.zzVC);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzVo.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                    CastRemoteDisplayLocalService.this.zzVC = null;
                    CastRemoteDisplayLocalService.this.zzVB = null;
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)x0);
            }
        });
    }

    private void zzmn() {
        this.zzbb("stopRemoteDisplay");
        if (this.zzVs == null || !this.zzVs.isConnected()) {
            zzVo.zzc("Unable to stop the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.stopRemoteDisplay(this.zzVs).setResultCallback(new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    CastRemoteDisplayLocalService.this.zzbb("Unable to stop the remote display, result unsuccessful");
                } else {
                    CastRemoteDisplayLocalService.this.zzbb("remote display stopped");
                }
                CastRemoteDisplayLocalService.this.zzVA = null;
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)x0);
            }
        });
    }

    private void zzmo() {
        if (this.zzVu != null) {
            this.zzVu.onRemoteDisplaySessionError(new Status(2200));
            this.zzVu = null;
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private void zzmp() {
        this.zzbb("stopRemoteDisplaySession");
        this.zzmn();
        this.onDismissPresentation();
    }

    private void zzmq() {
        this.zzbb("Stopping the remote display Service");
        this.stopForeground(true);
        this.stopSelf();
    }

    private GoogleApiClient zza(CastDevice castDevice) {
        CastRemoteDisplay.CastRemoteDisplayOptions.Builder builder = new CastRemoteDisplay.CastRemoteDisplayOptions.Builder(castDevice, this.zzVt);
        GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

            @Override
            public void onConnected(Bundle bundle) {
                CastRemoteDisplayLocalService.this.zzbb("onConnected");
                CastRemoteDisplayLocalService.this.zzmm();
            }

            @Override
            public void onConnectionSuspended(int cause) {
                zzVo.zzf(String.format("[Instance: %s] ConnectionSuspended %d", this, cause), new Object[0]);
            }
        };
        GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

            @Override
            public void onConnectionFailed(ConnectionResult connectionResult) {
                CastRemoteDisplayLocalService.this.zzbe("Connection failed: " + connectionResult);
                CastRemoteDisplayLocalService.this.zzmo();
            }
        };
        return new GoogleApiClient.Builder((Context)this, connectionCallbacks, onConnectionFailedListener).addApi(CastRemoteDisplay.API, builder.build()).build();
    }

    private PendingIntent zzmr() {
        if (this.zzVy == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            this.zzVy = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0x10000000);
        }
        return this.zzVy;
    }

    private Notification zzS(boolean bl) {
        int n;
        int n2;
        this.zzbb("createDefaultNotification");
        int n3 = this.getApplicationInfo().labelRes;
        String string2 = this.zzVw.zzVO;
        String string3 = this.zzVw.zzVP;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? this.getString(n3) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzVz.getFriendlyName()}) : string3;
        Notification notification = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzVw.zzVN).setSmallIcon(n).setOngoing(true).addAction(17301560, (CharSequence)this.getString(R.string.cast_notification_disconnect), this.zzmr()).build();
        return notification;
    }

    private void zzbb(String string2) {
        zzVo.zzb("[Instance: %s] %s", new Object[]{this, string2});
    }

    private void zzbe(String string2) {
        zzVo.zzc("[Instance: %s] %s", new Object[]{this, string2});
    }

    private class zza
    extends Binder {
        private zza() {
        }

        CastRemoteDisplayLocalService zzmw() {
            return CastRemoteDisplayLocalService.this;
        }
    }

    private static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                zzVo.zzb("disconnecting", new Object[0]);
                CastRemoteDisplayLocalService.stopService();
            }
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent zzVN;
        private String zzVO;
        private String zzVP;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings newSettings) {
            this.mNotification = newSettings.mNotification;
            this.zzVN = newSettings.zzVN;
            this.zzVO = newSettings.zzVO;
            this.zzVP = newSettings.zzVP;
        }

        public static final class Builder {
            private NotificationSettings zzVQ = new NotificationSettings();

            public Builder setNotification(Notification notification) {
                this.zzVQ.mNotification = notification;
                return this;
            }

            public Builder setNotificationPendingIntent(PendingIntent notificationPendingIntent) {
                this.zzVQ.zzVN = notificationPendingIntent;
                return this;
            }

            public Builder setNotificationTitle(String notificationTitle) {
                this.zzVQ.zzVO = notificationTitle;
                return this;
            }

            public Builder setNotificationText(String notificationText) {
                this.zzVQ.zzVP = notificationText;
                return this;
            }

            public NotificationSettings build() {
                if (this.zzVQ.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zzVQ.zzVO)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zzVQ.zzVP)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zzVQ.zzVN != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zzVQ.zzVO) && TextUtils.isEmpty((CharSequence)this.zzVQ.zzVP) && this.zzVQ.zzVN == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zzVQ;
            }
        }
    }

    public static interface Callbacks {
        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);
    }
}

