/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzmu;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    private MediaInfo zzWl;
    private int zzWm = 0;
    private boolean zzWn = true;
    private double zzWo;
    private double zzWp = Double.POSITIVE_INFINITY;
    private double zzWq;
    private long[] zzWr;
    private JSONObject zzWc;

    private MediaQueueItem(MediaInfo media) throws IllegalArgumentException {
        if (media == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzWl = media;
    }

    MediaQueueItem(JSONObject json) throws JSONException {
        this.zzg(json);
    }

    private MediaQueueItem(MediaQueueItem item) throws IllegalArgumentException {
        this.zzWl = item.getMedia();
        if (this.zzWl == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzWm = item.getItemId();
        this.zzWn = item.getAutoplay();
        this.zzWo = item.getStartTime();
        this.zzWp = item.getPlaybackDuration();
        this.zzWq = item.getPreloadTime();
        this.zzWr = item.getActiveTrackIds();
        this.zzWc = item.getCustomData();
    }

    public boolean zzg(JSONObject jSONObject) throws JSONException {
        double d;
        double d2;
        double d3;
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzWl = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzWm != (n = jSONObject.getInt("itemId"))) {
            this.zzWm = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzWn != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzWn = n;
            bl = true;
        }
        if (jSONObject.has("startTime") && Math.abs((d3 = jSONObject.getDouble("startTime")) - this.zzWo) > 1.0E-7) {
            this.zzWo = d3;
            bl = true;
        }
        if (jSONObject.has("playbackDuration") && Math.abs((d2 = jSONObject.getDouble("playbackDuration")) - this.zzWp) > 1.0E-7) {
            this.zzWp = d2;
            bl = true;
        }
        if (jSONObject.has("preloadTime") && Math.abs((d = jSONObject.getDouble("preloadTime")) - this.zzWq) > 1.0E-7) {
            this.zzWq = d;
            bl = true;
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzWr == null) {
                bl2 = true;
            } else if (this.zzWr.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzWr[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzWr = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzWc = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zzWl;
    }

    public int getItemId() {
        return this.zzWm;
    }

    void zzaR(int n) {
        this.zzWm = n;
    }

    public boolean getAutoplay() {
        return this.zzWn;
    }

    void zzU(boolean bl) {
        this.zzWn = bl;
    }

    public double getStartTime() {
        return this.zzWo;
    }

    void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzWo = d;
    }

    public double getPlaybackDuration() {
        return this.zzWp;
    }

    void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.zzWp = d;
    }

    public double getPreloadTime() {
        return this.zzWq;
    }

    void zze(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzWq = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzWr;
    }

    void zza(long[] lArray) {
        this.zzWr = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzWc;
    }

    void setCustomData(JSONObject customData) {
        this.zzWc = customData;
    }

    void zzmx() throws IllegalArgumentException {
        if (this.zzWl == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzWo) || this.zzWo < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzWp)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzWq) || this.zzWq < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzWl.toJson());
            if (this.zzWm != 0) {
                jSONObject.put("itemId", this.zzWm);
            }
            jSONObject.put("autoplay", this.zzWn);
            jSONObject.put("startTime", this.zzWo);
            if (this.zzWp != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzWp);
            }
            jSONObject.put("preloadTime", this.zzWq);
            if (this.zzWr != null) {
                JSONArray jSONArray = new JSONArray();
                for (long l2 : this.zzWr) {
                    jSONArray.put(l2);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzWc != null) {
                jSONObject.put("customData", (Object)this.zzWc);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)other;
        if (this.zzWc == null != (mediaQueueItem.zzWc == null)) {
            return false;
        }
        if (this.zzWc != null && mediaQueueItem.zzWc != null && !zzmu.zzd(this.zzWc, mediaQueueItem.zzWc)) {
            return false;
        }
        return zzf.zza(this.zzWl, mediaQueueItem.zzWl) && this.zzWm == mediaQueueItem.zzWm && this.zzWn == mediaQueueItem.zzWn && this.zzWo == mediaQueueItem.zzWo && this.zzWp == mediaQueueItem.zzWp && this.zzWq == mediaQueueItem.zzWq && zzf.zza(this.zzWr, mediaQueueItem.zzWr);
    }

    public int hashCode() {
        return zzw.hashCode(this.zzWl, this.zzWm, this.zzWn, this.zzWo, this.zzWp, this.zzWq, this.zzWr, String.valueOf(this.zzWc));
    }

    public static class Builder {
        private final MediaQueueItem zzWs;

        public Builder(MediaInfo media) throws IllegalArgumentException {
            this.zzWs = new MediaQueueItem(media);
        }

        public Builder(JSONObject json) throws JSONException {
            this.zzWs = new MediaQueueItem(json);
        }

        public Builder(MediaQueueItem item) throws IllegalArgumentException {
            this.zzWs = new MediaQueueItem(item);
        }

        public Builder clearItemId() {
            this.zzWs.zzaR(0);
            return this;
        }

        public Builder setAutoplay(boolean autoplay) {
            this.zzWs.zzU(autoplay);
            return this;
        }

        public Builder setStartTime(double startTime) throws IllegalArgumentException {
            this.zzWs.zzc(startTime);
            return this;
        }

        public Builder setPlaybackDuration(double playbackDuration) {
            this.zzWs.zzd(playbackDuration);
            return this;
        }

        public Builder setPreloadTime(double preloadTime) throws IllegalArgumentException {
            this.zzWs.zze(preloadTime);
            return this;
        }

        public Builder setActiveTrackIds(long[] activeTrackIds) {
            this.zzWs.zza(activeTrackIds);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzWs.setCustomData(customData);
            return this;
        }

        public MediaQueueItem build() {
            this.zzWs.zzmx();
            return this.zzWs;
        }
    }
}

