/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzmu;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    private long zzRr;
    private int zzWJ;
    private String zzVV;
    private String zzVX;
    private String mName;
    private String zzVT;
    private int zzWK;
    private JSONObject zzWc;

    MediaTrack(JSONObject json) throws JSONException {
        this.zzf(json);
    }

    MediaTrack(long id, int type) throws IllegalArgumentException {
        this.clear();
        this.zzRr = id;
        if (type <= 0 || type > 3) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.zzWJ = type;
    }

    public long getId() {
        return this.zzRr;
    }

    public int getType() {
        return this.zzWJ;
    }

    public String getContentId() {
        return this.zzVV;
    }

    public void setContentId(String contentId) {
        this.zzVV = contentId;
    }

    public String getContentType() {
        return this.zzVX;
    }

    public void setContentType(String contentType) {
        this.zzVX = contentType;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getLanguage() {
        return this.zzVT;
    }

    void setLanguage(String language) {
        this.zzVT = language;
    }

    public int getSubtype() {
        return this.zzWK;
    }

    void zzaV(int n) throws IllegalArgumentException {
        if (n <= -1 || n > 5) {
            throw new IllegalArgumentException("invalid subtype " + n);
        }
        if (n != 0 && this.zzWJ != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzWK = n;
    }

    public JSONObject getCustomData() {
        return this.zzWc;
    }

    void setCustomData(JSONObject customData) {
        this.zzWc = customData;
    }

    private void clear() {
        this.zzRr = 0L;
        this.zzWJ = 0;
        this.zzVV = null;
        this.mName = null;
        this.zzVT = null;
        this.zzWK = -1;
        this.zzWc = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zzf(JSONObject jSONObject) throws JSONException {
        this.clear();
        this.zzRr = jSONObject.getLong("trackId");
        String string2 = jSONObject.getString("type");
        if ("TEXT".equals(string2)) {
            this.zzWJ = 1;
        } else if ("AUDIO".equals(string2)) {
            this.zzWJ = 2;
        } else {
            if (!"VIDEO".equals(string2)) throw new JSONException("invalid type: " + string2);
            this.zzWJ = 3;
        }
        this.zzVV = jSONObject.optString("trackContentId", null);
        this.zzVX = jSONObject.optString("trackContentType", null);
        this.mName = jSONObject.optString("name", null);
        this.zzVT = jSONObject.optString("language", null);
        if (jSONObject.has("subtype")) {
            string2 = jSONObject.getString("subtype");
            if ("SUBTITLES".equals(string2)) {
                this.zzWK = 1;
            } else if ("CAPTIONS".equals(string2)) {
                this.zzWK = 2;
            } else if ("DESCRIPTIONS".equals(string2)) {
                this.zzWK = 3;
            } else if ("CHAPTERS".equals(string2)) {
                this.zzWK = 4;
            } else {
                if (!"METADATA".equals(string2)) throw new JSONException("invalid subtype: " + string2);
                this.zzWK = 5;
            }
        } else {
            this.zzWK = 0;
        }
        this.zzWc = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzRr);
            switch (this.zzWJ) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.zzVV != null) {
                jSONObject.put("trackContentId", (Object)this.zzVV);
            }
            if (this.zzVX != null) {
                jSONObject.put("trackContentType", (Object)this.zzVX);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzVT)) {
                jSONObject.put("language", (Object)this.zzVT);
            }
            switch (this.zzWK) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.zzWc != null) {
                jSONObject.put("customData", (Object)this.zzWc);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)other;
        if (this.zzWc == null != (mediaTrack.zzWc == null)) {
            return false;
        }
        if (this.zzWc != null && mediaTrack.zzWc != null && !zzmu.zzd(this.zzWc, mediaTrack.zzWc)) {
            return false;
        }
        return this.zzRr == mediaTrack.zzRr && this.zzWJ == mediaTrack.zzWJ && zzf.zza(this.zzVV, mediaTrack.zzVV) && zzf.zza(this.zzVX, mediaTrack.zzVX) && zzf.zza(this.mName, mediaTrack.mName) && zzf.zza(this.zzVT, mediaTrack.zzVT) && this.zzWK == mediaTrack.zzWK;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzRr, this.zzWJ, this.zzVV, this.zzVX, this.mName, this.zzVT, this.zzWK, this.zzWc);
    }

    public static class Builder {
        private final MediaTrack zzWL;

        public Builder(long trackId, int trackType) throws IllegalArgumentException {
            this.zzWL = new MediaTrack(trackId, trackType);
        }

        public Builder setContentId(String contentId) {
            this.zzWL.setContentId(contentId);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.zzWL.setContentType(contentType);
            return this;
        }

        public Builder setName(String trackName) {
            this.zzWL.setName(trackName);
            return this;
        }

        public Builder setLanguage(String language) {
            this.zzWL.setLanguage(language);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzWL.setLanguage(zzf.zzb(locale));
            return this;
        }

        public Builder setSubtype(int subtype) throws IllegalArgumentException {
            this.zzWL.zzaV(subtype);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzWL.setCustomData(customData);
            return this;
        }

        public MediaTrack build() {
            return this.zzWL;
        }
    }
}

