/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzmx;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    private float zzXw;
    private int zzXx;
    private int zzwg;
    private int zzXy;
    private int zzXz;
    private int zzXA;
    private int zzXB;
    private int zzXC;
    private String zzXD;
    private int zzXE;
    private int zzXF;
    private JSONObject zzWc;

    public TextTrackStyle() {
        this.clear();
    }

    public void setFontScale(float fontScale) {
        this.zzXw = fontScale;
    }

    public float getFontScale() {
        return this.zzXw;
    }

    public void setForegroundColor(int foregroundColor) {
        this.zzXx = foregroundColor;
    }

    public int getForegroundColor() {
        return this.zzXx;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.zzwg = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.zzwg;
    }

    public void setEdgeType(int edgeType) {
        if (edgeType < 0 || edgeType > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzXy = edgeType;
    }

    public int getEdgeType() {
        return this.zzXy;
    }

    public void setEdgeColor(int edgeColor) {
        this.zzXz = edgeColor;
    }

    public int getEdgeColor() {
        return this.zzXz;
    }

    public void setWindowType(int windowType) {
        if (windowType < 0 || windowType > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzXA = windowType;
    }

    public int getWindowType() {
        return this.zzXA;
    }

    public void setWindowColor(int windowColor) {
        this.zzXB = windowColor;
    }

    public int getWindowColor() {
        return this.zzXB;
    }

    public void setWindowCornerRadius(int windowCornerRadius) {
        if (windowCornerRadius < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzXC = windowCornerRadius;
    }

    public int getWindowCornerRadius() {
        return this.zzXC;
    }

    public void setFontFamily(String fontFamily) {
        this.zzXD = fontFamily;
    }

    public String getFontFamily() {
        return this.zzXD;
    }

    public void setFontGenericFamily(int fontGenericFamily) {
        if (fontGenericFamily < 0 || fontGenericFamily > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzXE = fontGenericFamily;
    }

    public int getFontGenericFamily() {
        return this.zzXE;
    }

    public void setFontStyle(int fontStyle) {
        if (fontStyle < 0 || fontStyle > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzXF = fontStyle;
    }

    public int getFontStyle() {
        return this.zzXF;
    }

    public void setCustomData(JSONObject customData) {
        this.zzWc = customData;
    }

    public JSONObject getCustomData() {
        return this.zzWc;
    }

    private void clear() {
        this.zzXw = 1.0f;
        this.zzXx = 0;
        this.zzwg = 0;
        this.zzXy = -1;
        this.zzXz = 0;
        this.zzXA = -1;
        this.zzXB = 0;
        this.zzXC = 0;
        this.zzXD = null;
        this.zzXE = -1;
        this.zzXF = -1;
        this.zzWc = null;
    }

    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzmx.zzqB()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void zzf(JSONObject jSONObject) throws JSONException {
        String string2;
        this.clear();
        this.zzXw = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzXx = this.zzbI(jSONObject.optString("foregroundColor"));
        this.zzwg = this.zzbI(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.zzXy = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.zzXy = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.zzXy = 2;
            } else if ("RAISED".equals(string2)) {
                this.zzXy = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.zzXy = 4;
            }
        }
        this.zzXz = this.zzbI(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.zzXA = 0;
            } else if ("NORMAL".equals(string2)) {
                this.zzXA = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.zzXA = 2;
            }
        }
        this.zzXB = this.zzbI(jSONObject.optString("windowColor"));
        if (this.zzXA == 2) {
            this.zzXC = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzXD = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.zzXE = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.zzXE = 1;
            } else if ("SERIF".equals(string2)) {
                this.zzXE = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.zzXE = 3;
            } else if ("CASUAL".equals(string2)) {
                this.zzXE = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.zzXE = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.zzXE = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.zzXF = 0;
            } else if ("BOLD".equals(string2)) {
                this.zzXF = 1;
            } else if ("ITALIC".equals(string2)) {
                this.zzXF = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.zzXF = 3;
            }
        }
        this.zzWc = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzXw);
            if (this.zzXx != 0) {
                jSONObject.put("foregroundColor", (Object)this.zzI(this.zzXx));
            }
            if (this.zzwg != 0) {
                jSONObject.put("backgroundColor", (Object)this.zzI(this.zzwg));
            }
            switch (this.zzXy) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
            }
            if (this.zzXz != 0) {
                jSONObject.put("edgeColor", (Object)this.zzI(this.zzXz));
            }
            switch (this.zzXA) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
            }
            if (this.zzXB != 0) {
                jSONObject.put("windowColor", (Object)this.zzI(this.zzXB));
            }
            if (this.zzXA == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzXC);
            }
            if (this.zzXD != null) {
                jSONObject.put("fontFamily", (Object)this.zzXD);
            }
            switch (this.zzXE) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
            }
            switch (this.zzXF) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
            }
            if (this.zzWc != null) {
                jSONObject.put("customData", (Object)this.zzWc);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String zzI(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private int zzbI(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string2.substring(1, 3), 16);
                int n2 = Integer.parseInt(string2.substring(3, 5), 16);
                int n3 = Integer.parseInt(string2.substring(5, 7), 16);
                int n4 = Integer.parseInt(string2.substring(7, 9), 16);
                return Color.argb((int)n4, (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)other;
        if (this.zzWc == null != (textTrackStyle.zzWc == null)) {
            return false;
        }
        if (this.zzWc != null && textTrackStyle.zzWc != null && !zzmu.zzd(this.zzWc, textTrackStyle.zzWc)) {
            return false;
        }
        return this.zzXw == textTrackStyle.zzXw && this.zzXx == textTrackStyle.zzXx && this.zzwg == textTrackStyle.zzwg && this.zzXy == textTrackStyle.zzXy && this.zzXz == textTrackStyle.zzXz && this.zzXA == textTrackStyle.zzXA && this.zzXC == textTrackStyle.zzXC && zzf.zza(this.zzXD, textTrackStyle.zzXD) && this.zzXE == textTrackStyle.zzXE && this.zzXF == textTrackStyle.zzXF;
    }

    public int hashCode() {
        return zzw.hashCode(Float.valueOf(this.zzXw), this.zzXx, this.zzwg, this.zzXy, this.zzXz, this.zzXA, this.zzXB, this.zzXC, this.zzXD, this.zzXE, this.zzXF, this.zzWc);
    }
}

