/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.os.SystemClock;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zzc;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzm
extends zzc {
    private static final String NAMESPACE = zzf.zzbN("com.google.cast.media");
    private long zzZq;
    private MediaStatus zzZr;
    private final List<zzp> zzXI;
    private final zzp zzZs = new zzp(86400000L);
    private final zzp zzZt = new zzp(86400000L);
    private final zzp zzZu = new zzp(86400000L);
    private final zzp zzZv = new zzp(86400000L);
    private final zzp zzZw = new zzp(86400000L);
    private final zzp zzZx = new zzp(86400000L);
    private final zzp zzZy = new zzp(86400000L);
    private final zzp zzZz = new zzp(86400000L);
    private final zzp zzZA = new zzp(86400000L);
    private final zzp zzZB = new zzp(86400000L);
    private final zzp zzZC = new zzp(86400000L);
    private final zzp zzZD = new zzp(86400000L);
    private final zzp zzZE = new zzp(86400000L);
    private final zzp zzZF = new zzp(86400000L);

    public zzm(String string2) {
        super(NAMESPACE, "MediaControlChannel", string2, 1000L);
        this.zzXI = new ArrayList<zzp>();
        this.zzXI.add(this.zzZs);
        this.zzXI.add(this.zzZt);
        this.zzXI.add(this.zzZu);
        this.zzXI.add(this.zzZv);
        this.zzXI.add(this.zzZw);
        this.zzXI.add(this.zzZx);
        this.zzXI.add(this.zzZy);
        this.zzXI.add(this.zzZz);
        this.zzXI.add(this.zzZA);
        this.zzXI.add(this.zzZB);
        this.zzXI.add(this.zzZC);
        this.zzXI.add(this.zzZD);
        this.zzXI.add(this.zzZE);
        this.zzXI.add(this.zzZF);
        this.zzni();
    }

    public long zza(zzo zzo2, MediaInfo mediaInfo, boolean bl, long l2, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.zzmQ();
        this.zzZs.zza(l3, zzo2);
        this.zzV(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.toJson());
            jSONObject2.put("autoplay", bl);
            jSONObject2.put("currentTime", zzf.zzA(l2));
            if (lArray != null) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long zza(zzo zzo2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzmQ();
        this.zzZt.zza(l2, zzo2);
        this.zzV(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzmy());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zzb(zzo zzo2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzmQ();
        this.zzZv.zza(l2, zzo2);
        this.zzV(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzmy());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zzc(zzo zzo2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzmQ();
        this.zzZu.zza(l2, zzo2);
        this.zzV(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzmy());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzo zzo2, long l2, int n, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.zzmQ();
        this.zzZw.zza(l3, zzo2);
        this.zzV(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zzmy());
            jSONObject2.put("currentTime", zzf.zzA(l2));
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long zza(zzo zzo2, double d, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzmQ();
        this.zzZx.zza(l2, zzo2);
        this.zzV(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzmy());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzo zzo2, boolean bl, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzmQ();
        this.zzZy.zza(l2, zzo2);
        this.zzV(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzmy());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzo zzo2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.zzmQ();
        this.zzZz.zza(l2, zzo2);
        this.zzV(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzZr != null) {
                jSONObject.put("mediaSessionId", this.zzZr.zzmy());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l2, null);
        return l2;
    }

    public long zza(zzo zzo2, long[] lArray) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.zzmQ();
        this.zzZA.zza(l2, zzo2);
        this.zzV(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzmy());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l2, null);
        return l2;
    }

    public long zza(zzo zzo2, TextTrackStyle textTrackStyle) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.zzmQ();
        this.zzZB.zza(l2, zzo2);
        this.zzV(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zzmy());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l2, null);
        return l2;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zzZq == 0L) {
            return 0L;
        }
        double d = this.zzZr.getPlaybackRate();
        long l2 = this.zzZr.getStreamPosition();
        int n = this.zzZr.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l2;
        }
        long l3 = SystemClock.elapsedRealtime() - this.zzZq;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l2;
        }
        long l4 = mediaInfo.getStreamDuration();
        long l5 = l2 + (long)((double)l3 * d);
        if (l4 > 0L && l5 > l4) {
            l5 = l4;
        } else if (l5 < 0L) {
            l5 = 0L;
        }
        return l5;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.zzZr;
    }

    public MediaInfo getMediaInfo() {
        return this.zzZr == null ? null : this.zzZr.getMediaInfo();
    }

    public long zza(zzo zzo2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l2, JSONObject jSONObject) throws IOException, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= mediaQueueItemArray.length) {
            throw new IllegalArgumentException("Invalid startIndex: " + n);
        }
        if (l2 != -1L && l2 < 0L) {
            throw new IllegalArgumentException("playPosition can not be negative: " + l2);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.zzmQ();
        this.zzZs.zza(l3, zzo2);
        this.zzV(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            switch (n2) {
                case 0: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                    break;
                }
                case 1: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                    break;
                }
                case 2: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                    break;
                }
                case 3: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid repeat mode: " + n2);
                }
            }
            jSONObject2.put("startIndex", n);
            if (l2 != -1L) {
                jSONObject2.put("currentTime", zzf.zzA(l2));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long zza(zzo zzo2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, int n3, long l2, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalStateException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        if (n2 != 0 && n3 != -1) {
            throw new IllegalArgumentException("can not set both currentItemId and currentItemIndexInItemsToInsert");
        }
        if (n3 != -1 && (n3 < 0 || n3 >= mediaQueueItemArray.length)) {
            throw new IllegalArgumentException(String.format("currentItemIndexInItemsToInsert %d out of range [0, %d).", n3, mediaQueueItemArray.length));
        }
        if (l2 != -1L && l2 < 0L) {
            throw new IllegalArgumentException("playPosition can not be negative: " + l2);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.zzmQ();
        this.zzZC.zza(l3, zzo2);
        this.zzV(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zzmy());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (n2 != 0) {
                jSONObject2.put("currentItemId", n2);
            }
            if (n3 != -1) {
                jSONObject2.put("currentItemIndex", n3);
            }
            if (l2 != -1L) {
                jSONObject2.put("currentTime", zzf.zzA(l2));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long zza(zzo zzo2, int n, long l2, MediaQueueItem[] mediaQueueItemArray, int n2, Integer n3, JSONObject jSONObject) throws IOException, IllegalStateException {
        if (l2 != -1L && l2 < 0L) {
            throw new IllegalArgumentException("playPosition cannot be negative: " + l2);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.zzmQ();
        this.zzZD.zza(l3, zzo2);
        this.zzV(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zzmy());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && mediaQueueItemArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                    jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                        break;
                    }
                    case 1: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                        break;
                    }
                    case 2: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                        break;
                    }
                    case 3: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                        break;
                    }
                }
            }
            if (l2 != -1L) {
                jSONObject2.put("currentTime", zzf.zzA(l2));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long zza(zzo zzo2, int[] nArray, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzmQ();
        this.zzZE.zza(l2, zzo2);
        this.zzV(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zzmy());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzo zzo2, int[] nArray, int n, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzmQ();
        this.zzZF.zza(l2, zzo2);
        this.zzV(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zzmy());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    @Override
    public final void zzbK(String string2) {
        this.zzYC.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l2 = jSONObject.optLong("requestId", -1L);
            if (string3.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.zza(l2, jSONArray.getJSONObject(0));
                } else {
                    this.zzZr = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.onQueueStatusUpdated();
                    this.onPreloadStatusUpdated();
                    this.zzZz.zzc(l2, 0);
                }
            } else if (string3.equals("INVALID_PLAYER_STATE")) {
                this.zzYC.zzf("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                for (zzp zzp2 : this.zzXI) {
                    zzp2.zzc(l2, 2100, jSONObject2);
                }
            } else if (string3.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.zzZs.zzc(l2, 2100, jSONObject3);
            } else if (string3.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.zzZs.zzc(l2, 2101, jSONObject4);
            } else if (string3.equals("INVALID_REQUEST")) {
                this.zzYC.zzf("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                for (zzp zzp3 : this.zzXI) {
                    zzp3.zzc(l2, 2100, jSONObject5);
                }
            }
        }
        catch (JSONException jSONException) {
            this.zzYC.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
        }
    }

    private void zza(long l2, JSONObject jSONObject) throws JSONException {
        boolean bl = this.zzZs.zzB(l2);
        boolean bl2 = this.zzZw.zznk() && !this.zzZw.zzB(l2);
        boolean bl3 = this.zzZx.zznk() && !this.zzZx.zzB(l2) || this.zzZy.zznk() && !this.zzZy.zzB(l2);
        int n = 0;
        if (bl2) {
            n |= 2;
        }
        if (bl3) {
            n |= 1;
        }
        int n2 = 0;
        if (bl || this.zzZr == null) {
            this.zzZr = new MediaStatus(jSONObject);
            this.zzZq = SystemClock.elapsedRealtime();
            n2 = 31;
        } else {
            n2 = this.zzZr.zza(jSONObject, n);
        }
        if ((n2 & 1) != 0) {
            this.zzZq = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n2 & 2) != 0) {
            this.zzZq = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n2 & 4) != 0) {
            this.onMetadataUpdated();
        }
        if ((n2 & 8) != 0) {
            this.onQueueStatusUpdated();
        }
        if ((n2 & 0x10) != 0) {
            this.onPreloadStatusUpdated();
        }
        for (zzp zzp2 : this.zzXI) {
            zzp2.zzc(l2, 0);
        }
    }

    public long zzmy() throws IllegalStateException {
        if (this.zzZr == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.zzZr.zzmy();
    }

    protected void onStatusUpdated() {
    }

    protected void onMetadataUpdated() {
    }

    protected void onQueueStatusUpdated() {
    }

    protected void onPreloadStatusUpdated() {
    }

    private void zzni() {
        this.zzZq = 0L;
        this.zzZr = null;
        for (zzp zzp2 : this.zzXI) {
            zzp2.clear();
        }
    }

    @Override
    public void zzmP() {
        super.zzmP();
        this.zzni();
    }

    @Override
    public void zzb(long l2, int n) {
        for (zzp zzp2 : this.zzXI) {
            zzp2.zzc(l2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzz(long l2) {
        for (zzp object2 : this.zzXI) {
            object2.zzd(l2, 2102);
        }
        boolean bl = false;
        Object object = zzp.zzZJ;
        synchronized (object) {
            for (zzp zzp2 : this.zzXI) {
                if (!zzp2.zznk()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

