/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;

public final class Status
implements Result,
SafeParcelable {
    public static final Status zzabb = new Status(0);
    public static final Status zzabc = new Status(14);
    public static final Status zzabd = new Status(8);
    public static final Status zzabe = new Status(15);
    public static final Status zzabf = new Status(16);
    public static final Parcelable.Creator<Status> CREATOR = new zzd();
    private final int mVersionCode;
    private final int zzYm;
    private final String zzZZ;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.mVersionCode = versionCode;
        this.zzYm = statusCode;
        this.zzZZ = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(statusCode, null);
    }

    public Status(int statusCode, String statusMessage) {
        this(1, statusCode, statusMessage, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent zznH() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.zzZZ;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.zzYm <= 0;
    }

    public boolean isCanceled() {
        return this.zzYm == 16;
    }

    public boolean isInterrupted() {
        return this.zzYm == 14;
    }

    public int getStatusCode() {
        return this.zzYm;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzw.hashCode(this.mVersionCode, this.zzYm, this.zzZZ, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.mVersionCode == status.mVersionCode && this.zzYm == status.zzYm && zzw.equal(this.zzZZ, status.zzZZ) && zzw.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String zznI() {
        if (this.zzZZ != null) {
            return this.zzZZ;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzYm);
    }

    public String toString() {
        return zzw.zzv(this).zzg("statusCode", this.zznI()).zzg("resolution", this.mPendingIntent).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

