/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.ValidateAccountRequest;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.common.internal.zzx;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzj<T extends IInterface>
implements Api.zzb,
zzk.zza {
    private final Context mContext;
    private final com.google.android.gms.common.internal.zzf zzabI;
    private final Looper zzaaO;
    private final zzl zzafx;
    private final GoogleApiAvailability zzaaP;
    final Handler mHandler;
    private final Object zzpd = new Object();
    private zzs zzafy;
    private GoogleApiClient.zza zzafz;
    private T zzafA;
    private final ArrayList<zzc<?>> zzafB = new ArrayList();
    private zze zzafC;
    private int zzafD = 1;
    private final Set<Scope> zzTm;
    private final Account zzQd;
    private final GoogleApiClient.ConnectionCallbacks zzafE;
    private final GoogleApiClient.OnConnectionFailedListener zzafF;
    private final int zzafG;
    protected AtomicInteger zzafH = new AtomicInteger(0);
    public static final String[] zzafI = new String[]{"service_esmobile", "service_googleme"};

    protected zzj(Context context, Looper looper, int n, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, zzl.zzal(context), GoogleApiAvailability.getInstance(), n, zzf2, zzx.zzw(connectionCallbacks), zzx.zzw(onConnectionFailedListener));
    }

    protected zzj(Context context, Looper looper, zzl zzl2, GoogleApiAvailability googleApiAvailability, int n, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.mContext = zzx.zzb(context, (Object)"Context must not be null");
        this.zzaaO = zzx.zzb(looper, (Object)"Looper must not be null");
        this.zzafx = zzx.zzb(zzl2, (Object)"Supervisor must not be null");
        this.zzaaP = zzx.zzb(googleApiAvailability, (Object)"API availability must not be null");
        this.mHandler = new zzb(looper);
        this.zzafG = n;
        this.zzabI = zzx.zzw(zzf2);
        this.zzQd = zzf2.getAccount();
        this.zzTm = this.zza(zzf2.zzoL());
        this.zzafE = connectionCallbacks;
        this.zzafF = onConnectionFailedListener;
    }

    private Set<Scope> zza(Set<Scope> set) {
        Set<Scope> set2 = this.zzb(set);
        if (set2 == null) {
            return set2;
        }
        for (Scope scope : set2) {
            if (set.contains(scope)) continue;
            throw new IllegalStateException("Expanding scopes is not permitted, use implied scopes instead");
        }
        return set2;
    }

    protected Set<Scope> zzb(Set<Scope> set) {
        return set;
    }

    protected abstract String zzfK();

    protected abstract String zzfL();

    protected final String zzoV() {
        return this.zzabI.zzoO();
    }

    protected abstract T zzW(IBinder var1);

    protected void zzoW() {
    }

    protected void onConnectionSuspended(int cause) {
    }

    protected void onConnectionFailed(ConnectionResult result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(int n, T t) {
        zzx.zzaa(n == 3 == (t != null));
        Object object = this.zzpd;
        synchronized (object) {
            this.zzafD = n;
            this.zzafA = t;
            this.zzc(n, t);
            switch (n) {
                case 2: {
                    this.zzoX();
                    break;
                }
                case 3: {
                    this.zzoW();
                    break;
                }
                case 1: {
                    this.zzoY();
                }
            }
        }
    }

    protected void zzc(int n, T t) {
    }

    private void zzoX() {
        if (this.zzafC != null) {
            Log.e((String)"GmsClient", (String)("Calling connect() while still connected, missing disconnect() for " + this.zzfK()));
            this.zzafx.zzb(this.zzfK(), (ServiceConnection)this.zzafC, this.zzoV());
            this.zzafH.incrementAndGet();
        }
        this.zzafC = new zze(this.zzafH.get());
        boolean bl = this.zzafx.zza(this.zzfK(), (ServiceConnection)this.zzafC, this.zzoV());
        if (!bl) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.zzfK()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzafH.get(), 9));
        }
    }

    private void zzoY() {
        if (this.zzafC != null) {
            this.zzafx.zzb(this.zzfK(), (ServiceConnection)this.zzafC, this.zzoV());
            this.zzafC = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzafD != n) {
                return false;
            }
            this.zzb(n2, t);
            return true;
        }
    }

    public void zzoZ() {
        int n = this.zzaaP.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zzb(1, null);
            this.zzafz = new zzf();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzafH.get(), n));
            return;
        }
        this.zza(new zzf());
    }

    @Override
    public void zza(GoogleApiClient.zza zza2) {
        this.zzafz = zzx.zzb(zza2, (Object)"Connection progress callbacks cannot be null.");
        this.zzb(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzafD == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzafD == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.zzafH.incrementAndGet();
        ArrayList<zzc<?>> arrayList = this.zzafB;
        synchronized (arrayList) {
            int n = this.zzafB.size();
            for (int i = 0; i < n; ++i) {
                this.zzafB.get(i).zzpi();
            }
            this.zzafB.clear();
        }
        this.zzb(1, null);
    }

    public void zzbE(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, this.zzafH.get(), n));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzaaO;
    }

    public final Account zzoI() {
        return this.zzQd != null ? this.zzQd : new Account("<<default account>>", "com.google");
    }

    protected final com.google.android.gms.common.internal.zzf zzpa() {
        return this.zzabI;
    }

    protected Bundle zzly() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzg(n, iBinder, bundle)));
    }

    protected void zza(int n, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n2, -1, (Object)new zzi(n, bundle)));
    }

    protected void zzbF(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, n, -1, (Object)new zzh()));
    }

    protected final void zzpb() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle zzmS() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzpc() throws DeadObjectException {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzafD == 4) {
                throw new DeadObjectException();
            }
            this.zzpb();
            zzx.zza(this.zzafA != null, (Object)"Client is connected but service is null");
            return this.zzafA;
        }
    }

    @Override
    public void zza(zzp zzp2) {
        Bundle bundle = this.zzpd();
        ValidateAccountRequest validateAccountRequest = new ValidateAccountRequest(zzp2, this.zzTm.toArray(new Scope[this.zzTm.size()]), this.mContext.getPackageName(), bundle);
        try {
            this.zzafy.zza((zzr)new zzd(this, this.zzafH.get()), validateAccountRequest);
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzbE(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    protected Bundle zzpd() {
        return null;
    }

    @Override
    public void zza(zzp zzp2, Set<Scope> set) {
        try {
            Bundle bundle = this.zzly();
            GetServiceRequest getServiceRequest = new GetServiceRequest(this.zzafG).zzcl(this.mContext.getPackageName()).zzg(bundle);
            if (set != null) {
                getServiceRequest.zzd(set);
            }
            if (this.zzlN()) {
                getServiceRequest.zzc(this.zzoI()).zzc(zzp2);
            } else if (this.zzpe()) {
                getServiceRequest.zzc(this.zzQd);
            }
            this.zzafy.zza((zzr)new zzd(this, this.zzafH.get()), getServiceRequest);
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzbE(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    @Override
    public boolean zzlN() {
        return false;
    }

    public boolean zzpe() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        T t;
        int n;
        Object object = this.zzpd;
        synchronized (object) {
            n = this.zzafD;
            t = this.zzafA;
        }
        writer.append(prefix).append("mConnectState=");
        switch (n) {
            case 2: {
                writer.print("CONNECTING");
                break;
            }
            case 3: {
                writer.print("CONNECTED");
                break;
            }
            case 4: {
                writer.print("DISCONNECTING");
                break;
            }
            case 1: {
                writer.print("DISCONNECTED");
                break;
            }
            default: {
                writer.print("UNKNOWN");
            }
        }
        writer.append(" mService=");
        if (t == null) {
            writer.println("null");
        } else {
            writer.append(this.zzfL()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
    }

    @Override
    public IBinder zznz() {
        if (this.zzafy == null) {
            return null;
        }
        return this.zzafy.asBinder();
    }

    public static final class zzd
    extends zzr.zza {
        private zzj zzafM;
        private final int zzafN;

        public zzd(zzj zzj2, int n) {
            this.zzafM = zzj2;
            this.zzafN = n;
        }

        @Override
        public void zzb(int n, Bundle bundle) {
            zzx.zzb(this.zzafM, (Object)"onAccountValidationComplete can be called only once per call to validateAccount");
            this.zzafM.zza(n, bundle, this.zzafN);
            this.zzpj();
        }

        @Override
        public void zza(int n, IBinder iBinder, Bundle bundle) {
            zzx.zzb(this.zzafM, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.zzafM.zza(n, iBinder, bundle, this.zzafN);
            this.zzpj();
        }

        private void zzpj() {
            this.zzafM = null;
        }
    }

    private abstract class zza
    extends zzc<Boolean> {
        public final int statusCode;
        public final Bundle zzafJ;

        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzafJ = bundle;
        }

        protected abstract boolean zzpf();

        protected abstract void zzh(ConnectionResult var1);

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zzj.this.zzb(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zzpf()) break;
                    zzj.this.zzb(1, null);
                    this.zzh(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zzj.this.zzb(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zzj.this.zzb(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.zzafJ != null) {
                        pendingIntent = (PendingIntent)this.zzafJ.getParcelable("pendingIntent");
                    }
                    this.zzh(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void zzpg() {
        }

        @Override
        protected /* synthetic */ void zzt(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzg
    extends zza {
        public final IBinder zzafO;

        public zzg(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzafO = iBinder;
        }

        @Override
        protected void zzh(ConnectionResult connectionResult) {
            if (zzj.this.zzafF != null) {
                zzj.this.zzafF.onConnectionFailed(connectionResult);
            }
            zzj.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzpf() {
            String string2;
            try {
                string2 = this.zzafO.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zzj.this.zzfL().equals(string2)) {
                Log.e((String)"GmsClient", (String)("service descriptor mismatch: " + zzj.this.zzfL() + " vs. " + string2));
                return false;
            }
            Object t = zzj.this.zzW(this.zzafO);
            if (t != null && zzj.this.zza(2, 3, t)) {
                Bundle bundle = zzj.this.zzmS();
                if (zzj.this.zzafE != null) {
                    zzj.this.zzafE.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzi
    extends zza {
        public zzi(int n, Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected void zzh(ConnectionResult connectionResult) {
            zzj.this.zzafz.zzb(connectionResult);
            zzj.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzpf() {
            zzj.this.zzafz.zzb(ConnectionResult.zzZY);
            return true;
        }
    }

    protected final class zzh
    extends zza {
        public zzh() {
            super(0, null);
        }

        @Override
        protected void zzh(ConnectionResult connectionResult) {
            zzj.this.zzafz.zza(connectionResult);
            zzj.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzpf() {
            zzj.this.zzafz.zza(ConnectionResult.zzZY);
            return true;
        }
    }

    protected class zzf
    implements GoogleApiClient.zza {
        @Override
        public void zza(ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                zzj.this.zza(null, zzj.this.zzTm);
            } else if (zzj.this.zzafF != null) {
                zzj.this.zzafF.onConnectionFailed(connectionResult);
            }
        }

        @Override
        public void zzb(ConnectionResult connectionResult) {
            throw new IllegalStateException("Legacy GmsClient received onReportAccountValidation callback.");
        }
    }

    protected abstract class zzc<TListener> {
        private TListener mListener;
        private boolean zzafL;

        public zzc(TListener TListener) {
            this.mListener = TListener;
            this.zzafL = false;
        }

        protected abstract void zzt(TListener var1);

        protected abstract void zzpg();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzph() {
            TListener TListener;
            zzc zzc2 = this;
            synchronized (zzc2) {
                TListener = this.mListener;
                if (this.zzafL) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.zzt(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzpg();
                    throw runtimeException;
                }
            } else {
                this.zzpg();
            }
            zzc2 = this;
            synchronized (zzc2) {
                this.zzafL = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzpi();
            ArrayList arrayList = zzj.this.zzafB;
            synchronized (arrayList) {
                zzj.this.zzafB.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzpi() {
            zzc zzc2 = this;
            synchronized (zzc2) {
                this.mListener = null;
            }
        }
    }

    final class zzb
    extends Handler {
        public zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (zzj.this.zzafH.get() != msg.arg1) {
                if (this.zzb(msg)) {
                    this.zza(msg);
                }
                return;
            }
            if (!(msg.what != 1 && msg.what != 5 && msg.what != 6 || zzj.this.isConnecting())) {
                this.zza(msg);
                return;
            }
            if (msg.what == 3) {
                ConnectionResult connectionResult = new ConnectionResult(msg.arg2, null);
                zzj.this.zzafz.zza(connectionResult);
                zzj.this.onConnectionFailed(connectionResult);
                return;
            }
            if (msg.what == 4) {
                zzj.this.zzb(4, null);
                if (zzj.this.zzafE != null) {
                    zzj.this.zzafE.onConnectionSuspended(msg.arg2);
                }
                zzj.this.onConnectionSuspended(msg.arg2);
                zzj.this.zza(4, 1, null);
                return;
            }
            if (msg.what == 2 && !zzj.this.isConnected()) {
                this.zza(msg);
                return;
            }
            if (this.zzb(msg)) {
                zzc zzc2 = (zzc)msg.obj;
                zzc2.zzph();
                return;
            }
            Log.wtf((String)"GmsClient", (String)("Don't know how to handle message: " + msg.what), (Throwable)new Exception());
        }

        private void zza(Message message) {
            zzc zzc2 = (zzc)message.obj;
            zzc2.zzpg();
            zzc2.unregister();
        }

        private boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 5 || message.what == 6;
        }
    }

    public final class zze
    implements ServiceConnection {
        private final int zzafN;

        public zze(int n) {
            this.zzafN = n;
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            zzx.zzb(binder, (Object)"Expecting a valid IBinder");
            zzj.this.zzafy = zzs.zza.zzaK(binder);
            zzj.this.zzbF(this.zzafN);
        }

        public void onServiceDisconnected(ComponentName component) {
            zzj.this.mHandler.sendMessage(zzj.this.mHandler.obtainMessage(4, this.zzafN, 1));
        }
    }
}

