/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Debug;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.common.stats.ConnectionEvent;
import com.google.android.gms.common.stats.zzc;
import com.google.android.gms.common.stats.zzd;
import com.google.android.gms.common.stats.zze;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zzmy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class zzb {
    private static final Object zzafW = new Object();
    private static zzb zzahy;
    private final List<String> zzahz;
    private final List<String> zzahA;
    private final List<String> zzahB;
    private final List<String> zzahC;
    private zze zzahD;
    private static Integer zzahE;
    private zze zzahF;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzb zzqh() {
        Object object = zzafW;
        synchronized (object) {
            if (zzahy == null) {
                zzahy = new zzb();
            }
        }
        return zzahy;
    }

    private zzb() {
        if (zzb.getLogLevel() == zzd.LOG_LEVEL_OFF) {
            this.zzahz = Collections.EMPTY_LIST;
            this.zzahA = Collections.EMPTY_LIST;
            this.zzahB = Collections.EMPTY_LIST;
            this.zzahC = Collections.EMPTY_LIST;
            return;
        }
        String string2 = zzc.zza.zzahI.get();
        this.zzahz = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzahJ.get();
        this.zzahA = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzahK.get();
        this.zzahB = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzahL.get();
        this.zzahC = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        this.zzahD = new zze(1024, zzc.zza.zzahM.get());
        this.zzahF = new zze(1024, zzc.zza.zzahM.get());
    }

    private boolean zzc(Context context, Intent intent) {
        ComponentName componentName = intent.getComponent();
        if (componentName == null || com.google.android.gms.common.internal.zzd.zzaeK && "com.google.android.gms".equals(componentName.getPackageName())) {
            return false;
        }
        return zzmm.zzl(context, componentName.getPackageName());
    }

    public boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n) {
        if (this.zzc(context, intent)) {
            Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
            return false;
        }
        boolean bl = context.bindService(intent, serviceConnection, n);
        if (bl) {
            this.zza(context, this.zzb(serviceConnection), string2, intent, 2);
        }
        return bl;
    }

    public boolean zza(Context context, Intent intent, ServiceConnection serviceConnection, int n) {
        return this.zza(context, context.getClass().getName(), intent, serviceConnection, n);
    }

    public void zza(Context context, ServiceConnection serviceConnection) {
        context.unbindService(serviceConnection);
        this.zza(context, this.zzb(serviceConnection), (String)null, (Intent)null, 1);
    }

    public void zza(Context context, ServiceConnection serviceConnection, String string2, Intent intent) {
        this.zza(context, this.zzb(serviceConnection), string2, intent, 3);
    }

    public void zzb(Context context, ServiceConnection serviceConnection) {
        this.zza(context, this.zzb(serviceConnection), (String)null, (Intent)null, 4);
    }

    private void zza(Context context, String string2, String string3, Intent intent, int n) {
        String string4;
        String string5;
        String string6;
        if (!this.zzqi() || this.zzahD == null) {
            return;
        }
        if (n == 4 || n == 1) {
            if (!this.zzahD.zzcy(string2)) {
                return;
            }
            string6 = null;
            string5 = null;
            string4 = null;
        } else {
            ServiceInfo serviceInfo = zzb.zzd(context, intent);
            if (serviceInfo == null) {
                Log.w((String)"ConnectionTracker", (String)String.format("Client %s made an invalid request %s", string3, intent.toUri(0)));
                return;
            }
            string6 = serviceInfo.processName;
            string5 = serviceInfo.name;
            string4 = zzmy.zzaq(context);
            if (!this.zzb(string4, string3, string6, string5)) {
                return;
            }
            this.zzahD.zzcx(string2);
        }
        this.zza(context, string2, n, string4, string3, string6, string5);
    }

    private void zza(Context context, String string2, int n, String string3, String string4, String string5, String string6) {
        long l2 = System.currentTimeMillis();
        String string7 = null;
        if ((zzb.getLogLevel() & zzd.zzahR) != 0 && n != 13) {
            string7 = zzmy.zzl(3, 5);
        }
        long l3 = 0L;
        if ((zzb.getLogLevel() & zzd.zzahT) != 0) {
            l3 = Debug.getNativeHeapAllocatedSize();
        }
        ConnectionEvent connectionEvent = n == 1 || n == 4 || n == 14 ? new ConnectionEvent(l2, n, null, null, null, null, string7, string2, SystemClock.elapsedRealtime(), l3) : new ConnectionEvent(l2, n, string3, string4, string5, string6, string7, string2, SystemClock.elapsedRealtime(), l3);
        context.startService(new Intent().setComponent(zzd.zzahN).putExtra("com.google.android.gms.common.stats.EXTRA_LOG_EVENT", (Parcelable)connectionEvent));
    }

    private boolean zzqi() {
        if (!com.google.android.gms.common.internal.zzd.zzaeK) {
            return false;
        }
        int n = zzb.getLogLevel();
        return n != zzd.LOG_LEVEL_OFF;
    }

    private boolean zzb(String string2, String string3, String string4, String string5) {
        int n = zzb.getLogLevel();
        return !this.zzahz.contains(string2) && !this.zzahA.contains(string3) && !this.zzahB.contains(string4) && !this.zzahC.contains(string5) && (!string4.equals(string2) || (n & zzd.zzahS) == 0);
    }

    private static ServiceInfo zzd(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentServices(intent, 128);
        if (list == null || list.size() == 0) {
            Log.w((String)"ConnectionTracker", (String)String.format("There are no handler of this intent: %s\n Stack trace: %s", intent.toUri(0), zzmy.zzl(3, 20)));
            return null;
        }
        if (list.size() > 1) {
            Log.w((String)"ConnectionTracker", (String)String.format("Multiple handlers found for this intent: %s\n Stack trace: %s", intent.toUri(0), zzmy.zzl(3, 20)));
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
                Log.w((String)"ConnectionTracker", (String)resolveInfo.serviceInfo.name);
                return null;
            }
        }
        return ((ResolveInfo)list.get((int)0)).serviceInfo;
    }

    private String zzb(ServiceConnection serviceConnection) {
        return String.valueOf((long)Process.myPid() << 32 | (long)System.identityHashCode(serviceConnection));
    }

    private static int getLogLevel() {
        if (zzahE == null) {
            try {
                zzahE = zzmm.zzjA() ? zzc.zza.zzahH.get() : zzd.LOG_LEVEL_OFF;
            }
            catch (SecurityException securityException) {
                zzahE = zzd.LOG_LEVEL_OFF;
            }
        }
        return zzahE;
    }
}

