/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.content.IntentSender;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.zzl;
import com.google.android.gms.drive.internal.zzv;

public class CreateFileActivityBuilder {
    public static final String EXTRA_RESPONSE_DRIVE_ID = "response_drive_id";
    private final zzl zzaiC = new zzl(0);
    private DriveContents zzaiD;
    private boolean zzaiE;

    public CreateFileActivityBuilder setInitialDriveContents(DriveContents driveContents) {
        if (driveContents != null) {
            if (!(driveContents instanceof zzv)) {
                throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
            }
            if (driveContents.getDriveId() != null) {
                throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
            }
            if (driveContents.zzqQ()) {
                throw new IllegalArgumentException("DriveContents are already closed.");
            }
            this.zzaiC.zzcI(driveContents.zzqO().getRequestId());
            this.zzaiD = driveContents;
        } else {
            this.zzaiC.zzcI(1);
        }
        this.zzaiE = true;
        return this;
    }

    public CreateFileActivityBuilder setInitialMetadata(MetadataChangeSet metadataChangeSet) {
        this.zzaiC.zza(metadataChangeSet);
        return this;
    }

    public CreateFileActivityBuilder setActivityStartFolder(DriveId folder) {
        this.zzaiC.zza(folder);
        return this;
    }

    public CreateFileActivityBuilder setActivityTitle(String title) {
        this.zzaiC.zzcE(title);
        return this;
    }

    public IntentSender build(GoogleApiClient apiClient) {
        zzx.zzb(Boolean.valueOf(this.zzaiE), (Object)"Must call setInitialDriveContents to CreateFileActivityBuilder.");
        zzx.zza(apiClient.isConnected(), (Object)"Client must be connected");
        if (this.zzaiD != null) {
            this.zzaiD.zzqP();
        }
        return this.zzaiC.build(apiClient);
    }
}

