/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.internal.DeleteResourceRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.ListParentsRequest;
import com.google.android.gms.drive.internal.OnListParentsResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.SetResourceParentsRequest;
import com.google.android.gms.drive.internal.TrashResourceRequest;
import com.google.android.gms.drive.internal.UntrashResourceRequest;
import com.google.android.gms.drive.internal.UpdateMetadataRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbt;
import com.google.android.gms.drive.internal.zzp;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.internal.zzlb;
import java.util.ArrayList;
import java.util.Set;

public class zzab
implements DriveResource {
    protected final DriveId zzaiA;

    public zzab(DriveId driveId) {
        this.zzaiA = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.zzaiA;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient apiClient) {
        return this.zza(apiClient, false);
    }

    private PendingResult<DriveResource.MetadataResult> zza(GoogleApiClient googleApiClient, final boolean bl) {
        return googleApiClient.zza(new zzd(googleApiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new GetMetadataRequest(zzab.this.zzaiA, bl), (zzan)new zzb(this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient apiClient) {
        return apiClient.zza(new zzs.zzg(apiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new ListParentsRequest(zzab.this.zzaiA), (zzan)new zza(this));
            }
        });
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient apiClient, Set<DriveId> parentIds) {
        if (parentIds == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        final ArrayList<DriveId> arrayList = new ArrayList<DriveId>(parentIds);
        return apiClient.zzb(new zzt.zza(apiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new SetResourceParentsRequest(zzab.this.zzaiA, arrayList), (zzan)new zzbt(this));
            }
        });
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return apiClient.zzb(new zzd(apiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                changeSet.zzqW().setContext(zzu2.getContext());
                zzu2.zzrm().zza(new UpdateMetadataRequest(zzab.this.zzaiA, changeSet.zzqW()), (zzan)new zzb(this));
            }
        });
    }

    @Override
    public PendingResult<Status> delete(GoogleApiClient apiClient) {
        return apiClient.zzb(new zzt.zza(apiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new DeleteResourceRequest(zzab.this.zzaiA), (zzan)new zzbt(this));
            }
        });
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        zzu zzu2 = apiClient.zza(Drive.zzRk);
        return zzu2.zza(apiClient, this.zzaiA, listener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        zzu zzu2 = apiClient.zza(Drive.zzRk);
        return zzu2.zzb(apiClient, this.zzaiA, listener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient apiClient) {
        zzu zzu2 = apiClient.zza(Drive.zzRk);
        return zzu2.zza(apiClient, this.zzaiA);
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient apiClient) {
        zzu zzu2 = apiClient.zza(Drive.zzRk);
        return zzu2.zzb(apiClient, this.zzaiA);
    }

    @Override
    public PendingResult<Status> trash(GoogleApiClient apiClient) {
        return apiClient.zzb(new zzt.zza(apiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new TrashResourceRequest(zzab.this.zzaiA), (zzan)new zzbt(this));
            }
        });
    }

    @Override
    public PendingResult<Status> untrash(GoogleApiClient apiClient) {
        return apiClient.zzb(new zzt.zza(apiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new UntrashResourceRequest(zzab.this.zzaiA), (zzan)new zzbt(this));
            }
        });
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlb.zzb<DriveApi.MetadataBufferResult> zzagy;

        public zza(zzlb.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzagy = zzb2;
        }

        @Override
        public void zza(OnListParentsResponse onListParentsResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListParentsResponse.zzrD());
            this.zzagy.zzp(new zzs.zzf(Status.zzabb, metadataBuffer, false));
        }

        @Override
        public void zzy(Status status) throws RemoteException {
            this.zzagy.zzp(new zzs.zzf(status, null, false));
        }
    }

    private static class zzb
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlb.zzb<DriveResource.MetadataResult> zzagy;

        public zzb(zzlb.zzb<DriveResource.MetadataResult> zzb2) {
            this.zzagy = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzagy.zzp(new zzc(Status.zzabb, new zzp(onMetadataResponse.zzrE())));
        }

        @Override
        public void zzy(Status status) throws RemoteException {
            this.zzagy.zzp(new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveResource.MetadataResult {
        private final Status zzSC;
        private final Metadata zzalr;

        public zzc(Status status, Metadata metadata) {
            this.zzSC = status;
            this.zzalr = metadata;
        }

        @Override
        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public Metadata getMetadata() {
            return this.zzalr;
        }
    }

    private abstract class zzd
    extends zzt<DriveResource.MetadataResult> {
        private zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveResource.MetadataResult zzG(Status status) {
            return new zzc(status, null);
        }

        @Override
        public /* synthetic */ Result zzb(Status status) {
            return this.zzG(status);
        }
    }
}

