/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableOptions;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.internal.AddEventListenerRequest;
import com.google.android.gms.drive.internal.CancelPendingActionsRequest;
import com.google.android.gms.drive.internal.DisconnectRequest;
import com.google.android.gms.drive.internal.RemoveEventListenerRequest;
import com.google.android.gms.drive.internal.zzae;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzao;
import com.google.android.gms.drive.internal.zzbt;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzu
extends zzj<zzam> {
    private final String zzRq;
    private final Bundle zzakC;
    private final boolean zzakD;
    private volatile DriveId zzakE;
    private volatile DriveId zzakF;
    private volatile boolean zzakG = false;
    final GoogleApiClient.ConnectionCallbacks zzafE;
    final Map<DriveId, Map<ChangeListener, zzae>> zzakH = new HashMap<DriveId, Map<ChangeListener, zzae>>();
    final Map<zzc, zzae> zzakI = new HashMap<zzc, zzae>();
    final Map<DriveId, Map<zzi, zzae>> zzakJ = new HashMap<DriveId, Map<zzi, zzae>>();
    final Map<DriveId, Map<zzi, zzae>> zzakK = new HashMap<DriveId, Map<zzi, zzae>>();

    public zzu(Context context, Looper looper, zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.zzRq = zzf2.zzoN();
        this.zzafE = connectionCallbacks;
        this.zzakC = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzakD = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    throw new IllegalStateException("Drive event service " + serviceInfo.name + " must be exported in AndroidManifest.xml");
                }
                this.zzakD = true;
                break;
            }
            default: {
                throw new IllegalStateException("AndroidManifest.xml can only define one service that handles the " + intent.getAction() + " action");
            }
        }
    }

    @Override
    public boolean zzlN() {
        return !this.getContext().getPackageName().equals(this.zzRq) || !this.zzrl();
    }

    @Override
    public boolean zzpe() {
        return true;
    }

    boolean zzrl() {
        return GooglePlayServicesUtil.zze(this.getContext(), Process.myUid());
    }

    protected zzam zzaR(IBinder iBinder) {
        return zzam.zza.zzaS(iBinder);
    }

    @Override
    protected String zzfL() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    @Override
    protected Bundle zzly() {
        String string2 = this.getContext().getPackageName();
        zzx.zzw(string2);
        zzx.zzZ(!this.zzpa().zzoL().isEmpty());
        Bundle bundle = new Bundle();
        if (!string2.equals(this.zzRq)) {
            bundle.putString("proxy_package_name", this.zzRq);
        }
        bundle.putAll(this.zzakC);
        return bundle;
    }

    @Override
    protected String zzfK() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public zzam zzrm() throws DeadObjectException {
        return (zzam)this.zzpc();
    }

    public DriveId zzrn() {
        return this.zzakE;
    }

    public DriveId zzro() {
        return this.zzakF;
    }

    public boolean zzrp() {
        return this.zzakG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Map<Object, Object> map;
        if (this.isConnected()) {
            try {
                map = (zzam)this.zzpc();
                map.zza(new DisconnectRequest());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        super.disconnect();
        map = this.zzakH;
        synchronized (map) {
            this.zzakH.clear();
        }
        map = this.zzakI;
        synchronized (map) {
            this.zzakI.clear();
        }
        map = this.zzakJ;
        synchronized (map) {
            this.zzakJ.clear();
        }
        map = this.zzakK;
        synchronized (map) {
            this.zzakK.clear();
        }
    }

    @Override
    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            this.zzakE = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzakF = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzakG = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public boolean zzrq() {
        return this.zzakD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        int n = 1;
        zzx.zzb(zzg.zza(n, driveId), (Object)"id");
        zzx.zzb(changeListener, (Object)"listener");
        zzx.zza(this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzae>> map = this.zzakH;
        synchronized (map) {
            zzae zzae2;
            Map<ChangeListener, zzae> map2 = this.zzakH.get(driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzae>();
                this.zzakH.put(driveId, map2);
            }
            if ((zzae2 = map2.get(changeListener)) == null) {
                zzae2 = new zzae(this.getLooper(), this.getContext(), n, changeListener);
                map2.put(changeListener, zzae2);
            } else if (zzae2.zzcQ(n)) {
                return new zzs.zzj(googleApiClient, Status.zzabb);
            }
            zzae2.zzcP(n);
            return this.zza(googleApiClient, n, driveId, zzae2, null);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final zzae zzae2, final ChangesAvailableOptions changesAvailableOptions) {
        return googleApiClient.zzb(new zzt.zza(googleApiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new AddEventListenerRequest(driveId, n, changesAvailableOptions), (zzao)zzae2, null, (zzan)new zzbt(this));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        int n = 1;
        zzx.zzb(zzg.zza(n, driveId), (Object)"id");
        zzx.zza(this.isConnected(), (Object)"Client must be connected");
        zzx.zzb(changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzae>> map = this.zzakH;
        synchronized (map) {
            Map<ChangeListener, zzae> map2 = this.zzakH.get(driveId);
            if (map2 == null) {
                return new zzs.zzj(googleApiClient, Status.zzabb);
            }
            zzae zzae2 = map2.remove(changeListener);
            if (zzae2 == null) {
                return new zzs.zzj(googleApiClient, Status.zzabb);
            }
            if (map2.isEmpty()) {
                this.zzakH.remove(driveId);
            }
            return this.zza(googleApiClient, n, driveId, zzae2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final zzae zzae2) {
        return googleApiClient.zzb(new zzt.zza(googleApiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new RemoveEventListenerRequest(driveId, n), (zzao)zzae2, null, (zzan)new zzbt(this));
            }
        });
    }

    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId, (ChangesAvailableOptions)null);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final ChangesAvailableOptions changesAvailableOptions) {
        zzx.zzb(zzg.zza(n, driveId), (Object)"id");
        zzx.zza(this.isConnected(), (Object)"Client must be connected");
        if (!this.zzakD) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.zzb(new zzt.zza(googleApiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new AddEventListenerRequest(driveId, n, changesAvailableOptions), null, null, (zzan)new zzbt(this));
            }
        });
    }

    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId) {
        zzx.zzb(zzg.zza(n, driveId), (Object)"id");
        zzx.zza(this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzb(new zzt.zza(googleApiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new RemoveEventListenerRequest(driveId, n), null, null, (zzan)new zzbt(this));
            }
        });
    }

    PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, final List<String> pendingTags) {
        zzx.zzaa(pendingTags != null);
        zzx.zzaa(!pendingTags.isEmpty());
        zzx.zza(this.isConnected(), (Object)"Client must be connected");
        return apiClient.zzb(new zzt.zza(apiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new CancelPendingActionsRequest(pendingTags), (zzan)new zzbt(this));
            }
        });
    }

    @Override
    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzaR(iBinder);
    }
}

