/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbl;
import com.google.android.gms.drive.internal.zzbt;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.internal.zzmt;
import java.io.InputStream;
import java.io.OutputStream;

public class zzv
implements DriveContents {
    private final Contents zzakR;
    private boolean mClosed = false;
    private boolean zzakS = false;
    private boolean zzakT = false;

    public zzv(Contents contents) {
        this.zzakR = zzx.zzw(contents);
    }

    @Override
    public DriveId getDriveId() {
        return this.zzakR.getDriveId();
    }

    @Override
    public int getMode() {
        return this.zzakR.getMode();
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.zzqQ()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzakR.getParcelFileDescriptor();
    }

    @Override
    public InputStream getInputStream() {
        if (this.zzqQ()) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzakR.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzakS) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzakS = true;
        return this.zzakR.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.zzqQ()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzakR.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzakT) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzakT = true;
        return this.zzakR.getOutputStream();
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient apiClient) {
        if (this.zzqQ()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzakR.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzqP();
        return apiClient.zza(new zzs.zzb(apiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new OpenContentsRequest(zzv.this.getDriveId(), 0x20000000, zzv.this.zzakR.getRequestId()), (zzan)new zzbl(this, null));
            }
        });
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet) {
        return this.commit(apiClient, changeSet, null);
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet, ExecutionOptions executionOptions) {
        if (executionOptions == null) {
            executionOptions = new ExecutionOptions.Builder().build();
        }
        if (this.zzakR.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.zzck(executionOptions.zzqU()) && !this.zzakR.zzqM()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        ExecutionOptions.zza(apiClient, executionOptions);
        if (this.zzqQ()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        final MetadataChangeSet metadataChangeSet = changeSet != null ? changeSet : MetadataChangeSet.zzajc;
        final ExecutionOptions executionOptions2 = executionOptions;
        this.zzqP();
        return apiClient.zzb(new zzt.zza(apiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                metadataChangeSet.zzqW().setContext(zzu2.getContext());
                zzu2.zzrm().zza(new CloseContentsAndUpdateMetadataRequest(zzv.this.zzakR.getDriveId(), metadataChangeSet.zzqW(), zzv.this.zzakR.getRequestId(), zzv.this.zzakR.zzqM(), executionOptions2), (zzan)new zzbt(this));
            }
        });
    }

    @Override
    public void discard(GoogleApiClient apiClient) {
        if (this.zzqQ()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzqP();
        apiClient.zzb(new zzt.zza(apiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new CloseContentsRequest(zzv.this.zzakR.getRequestId(), false), (zzan)new zzbt(this));
            }
        }).setResultCallback(new ResultCallback<Status>(){

            public void zzo(Status status) {
                if (!status.isSuccess()) {
                    zzz.zzz("DriveContentsImpl", "Error discarding contents");
                } else {
                    zzz.zzx("DriveContentsImpl", "Contents discarded");
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.zzo((Status)x0);
            }
        });
    }

    @Override
    public Contents zzqO() {
        return this.zzakR;
    }

    @Override
    public void zzqP() {
        zzmt.zza(this.zzakR.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public boolean zzqQ() {
        return this.mClosed;
    }
}

