/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CreateFileRequest;
import com.google.android.gms.drive.internal.CreateFolderRequest;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.zzab;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzv;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.internal.zzlb;

public class zzy
extends zzab
implements DriveFolder {
    public zzy(DriveId driveId) {
        super(driveId);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listChildren(GoogleApiClient apiClient) {
        return this.queryChildren(apiClient, null);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> queryChildren(GoogleApiClient apiClient, Query query) {
        return new zzs().query(apiClient, this.zza(query));
    }

    private Query zza(Query query) {
        Query.Builder builder = new Query.Builder().addFilter(Filters.in(SearchableField.PARENTS, this.getDriveId()));
        if (query != null) {
            if (query.getFilter() != null) {
                builder.addFilter(query.getFilter());
            }
            builder.setPageToken(query.getPageToken());
            builder.setSortOrder(query.getSortOrder());
        }
        return builder.build();
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient apiClient, MetadataChangeSet changeSet, DriveContents driveContents) {
        return this.createFile(apiClient, changeSet, driveContents, null);
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient apiClient, MetadataChangeSet changeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        if (executionOptions == null) {
            executionOptions = new ExecutionOptions.Builder().build();
        }
        if (executionOptions.zzqU() != 0) {
            throw new IllegalStateException("May not set a conflict strategy for calls to createFile.");
        }
        return this.zza(apiClient, changeSet, driveContents, executionOptions);
    }

    private PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        int n;
        if (driveContents != null) {
            if (!(driveContents instanceof zzv)) {
                throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
            }
            if (driveContents.getDriveId() != null) {
                throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
            }
            if (driveContents.zzqQ()) {
                throw new IllegalArgumentException("DriveContents are already closed.");
            }
            n = driveContents.zzqO().getRequestId();
            driveContents.zzqP();
        } else {
            n = 1;
        }
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if ("application/vnd.google-apps.folder".equals(metadataChangeSet.getMimeType())) {
            throw new IllegalArgumentException("May not create folders (mimetype: application/vnd.google-apps.folder) using this method. Use DriveFolder.createFolder() instead.");
        }
        return this.zza(googleApiClient, metadataChangeSet, n, 0, executionOptions);
    }

    private PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet, final int n, final int n2, final ExecutionOptions executionOptions) {
        ExecutionOptions.zza(googleApiClient, executionOptions);
        return googleApiClient.zzb(new zzd(googleApiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                metadataChangeSet.zzqW().setContext(zzu2.getContext());
                CreateFileRequest createFileRequest = new CreateFileRequest(zzy.this.getDriveId(), metadataChangeSet.zzqW(), n, n2, executionOptions);
                zzu2.zzrm().zza(createFileRequest, (zzan)new zza(this));
            }
        });
    }

    @Override
    public PendingResult<DriveFolder.DriveFolderResult> createFolder(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if (changeSet.getMimeType() != null && !changeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return apiClient.zzb(new zzf(apiClient){

            @Override
            protected void zza(zzu zzu2) throws RemoteException {
                changeSet.zzqW().setContext(zzu2.getContext());
                zzu2.zzrm().zza(new CreateFolderRequest(zzy.this.getDriveId(), changeSet.zzqW()), (zzan)new zzb(this));
            }
        });
    }

    private static class zzb
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlb.zzb<DriveFolder.DriveFolderResult> zzagy;

        public zzb(zzlb.zzb<DriveFolder.DriveFolderResult> zzb2) {
            this.zzagy = zzb2;
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzagy.zzp(new zze(Status.zzabb, new zzy(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void zzy(Status status) throws RemoteException {
            this.zzagy.zzp(new zze(status, null));
        }
    }

    private static class zze
    implements DriveFolder.DriveFolderResult {
        private final Status zzSC;
        private final DriveFolder zzalj;

        public zze(Status status, DriveFolder driveFolder) {
            this.zzSC = status;
            this.zzalj = driveFolder;
        }

        @Override
        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public DriveFolder getDriveFolder() {
            return this.zzalj;
        }
    }

    static abstract class zzf
    extends zzt<DriveFolder.DriveFolderResult> {
        zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFolderResult zzE(Status status) {
            return new zze(status, null);
        }

        @Override
        public /* synthetic */ Result zzb(Status status) {
            return this.zzE(status);
        }
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlb.zzb<DriveFolder.DriveFileResult> zzagy;

        public zza(zzlb.zzb<DriveFolder.DriveFileResult> zzb2) {
            this.zzagy = zzb2;
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzagy.zzp(new zzc(Status.zzabb, new zzw(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void zzy(Status status) throws RemoteException {
            this.zzagy.zzp(new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveFolder.DriveFileResult {
        private final Status zzSC;
        private final DriveFile zzali;

        public zzc(Status status, DriveFile driveFile) {
            this.zzSC = status;
            this.zzali = driveFile;
        }

        @Override
        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public DriveFile getDriveFile() {
            return this.zzali;
        }
    }

    static abstract class zzd
    extends zzt<DriveFolder.DriveFileResult> {
        zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFileResult zzD(Status status) {
            return new zzc(status, null);
        }

        @Override
        public /* synthetic */ Result zzb(Status status) {
            return this.zzD(status);
        }
    }
}

