/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.zze;
import com.google.android.gms.drive.metadata.internal.zzh;
import com.google.android.gms.internal.zznd;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class MetadataBundle
implements SafeParcelable {
    public static final Parcelable.Creator<MetadataBundle> CREATOR = new zzh();
    final int mVersionCode;
    final Bundle zzamG;

    MetadataBundle(int versionCode, Bundle valueBundle) {
        this.mVersionCode = versionCode;
        this.zzamG = zzx.zzw(valueBundle);
        this.zzamG.setClassLoader(this.getClass().getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.zzamG.keySet()) {
            if (zze.zzcF(string2) != null) continue;
            arrayList.add(string2);
            zzz.zzy("MetadataBundle", "Ignored unknown metadata field in bundle: " + string2);
        }
        for (String string2 : arrayList) {
            this.zzamG.remove(string2);
        }
    }

    private MetadataBundle(Bundle valueBundle) {
        this(1, valueBundle);
    }

    public static MetadataBundle zzrM() {
        return new MetadataBundle(new Bundle());
    }

    public static MetadataBundle zza(MetadataBundle metadataBundle) {
        return new MetadataBundle(new Bundle(metadataBundle.zzamG));
    }

    public static <T> MetadataBundle zza(MetadataField<T> metadataField, T t) {
        MetadataBundle metadataBundle = MetadataBundle.zzrM();
        metadataBundle.zzb(metadataField, t);
        return metadataBundle;
    }

    public <T> void zzb(MetadataField<T> metadataField, T t) {
        if (zze.zzcF(metadataField.getName()) == null) {
            throw new IllegalArgumentException("Unregistered field: " + metadataField.getName());
        }
        metadataField.zza(t, this.zzamG);
    }

    public <T> T zza(MetadataField<T> metadataField) {
        return metadataField.zzj(this.zzamG);
    }

    public boolean zzc(MetadataField<?> metadataField) {
        return this.zzamG.containsKey(metadataField.getName());
    }

    public Set<MetadataField<?>> zzrN() {
        HashSet hashSet = new HashSet();
        for (String string2 : this.zzamG.keySet()) {
            hashSet.add(zze.zzcF(string2));
        }
        return hashSet;
    }

    public void setContext(Context context) {
        BitmapTeleporter bitmapTeleporter = this.zza(zznd.zzano);
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(context.getCacheDir());
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        for (String string2 : this.zzamG.keySet()) {
            n2 = n2 * 31 + this.zzamG.get(string2).hashCode();
        }
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetadataBundle)) {
            return false;
        }
        MetadataBundle metadataBundle = (MetadataBundle)obj;
        Set set = this.zzamG.keySet();
        if (!set.equals(metadataBundle.zzamG.keySet())) {
            return false;
        }
        for (String string2 : set) {
            if (zzw.equal(this.zzamG.get(string2), metadataBundle.zzamG.get(string2))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MetadataBundle [values=" + this.zzamG + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzh.zza(this, dest, flags);
    }
}

