/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.query;

import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.SearchableCollectionMetadataField;
import com.google.android.gms.drive.metadata.SearchableMetadataField;
import com.google.android.gms.drive.metadata.SearchableOrderedMetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.drive.query.internal.ComparisonFilter;
import com.google.android.gms.drive.query.internal.FieldOnlyFilter;
import com.google.android.gms.drive.query.internal.HasFilter;
import com.google.android.gms.drive.query.internal.InFilter;
import com.google.android.gms.drive.query.internal.LogicalFilter;
import com.google.android.gms.drive.query.internal.NotFilter;
import com.google.android.gms.drive.query.internal.Operator;
import com.google.android.gms.drive.query.internal.OwnedByMeFilter;

public class Filters {
    public static <T> Filter eq(SearchableMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.zzaom, field, value);
    }

    public static <T extends Comparable<T>> Filter lessThan(SearchableOrderedMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.zzaon, field, value);
    }

    public static <T extends Comparable<T>> Filter greaterThan(SearchableOrderedMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.zzaop, field, value);
    }

    public static <T extends Comparable<T>> Filter lessThanEquals(SearchableOrderedMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.zzaoo, field, value);
    }

    public static <T extends Comparable<T>> Filter greaterThanEquals(SearchableOrderedMetadataField<T> field, T value) {
        return new ComparisonFilter<T>(Operator.zzaoq, field, value);
    }

    public static <T> Filter in(SearchableCollectionMetadataField<T> field, T value) {
        return new InFilter<T>(field, value);
    }

    public static Filter eq(CustomPropertyKey key, String value) {
        zzx.zzb(value != null, (Object)"Custom property value may not be null.");
        return new HasFilter<AppVisibleCustomProperties>(SearchableField.zzanR, new AppVisibleCustomProperties.zza().zza(key, value).zzrI());
    }

    public static Filter contains(SearchableMetadataField<String> field, String value) {
        return new ComparisonFilter<String>(Operator.zzaou, field, value);
    }

    public static Filter and(Filter filter, Filter ... additionalFilters) {
        return new LogicalFilter(Operator.zzaor, filter, additionalFilters);
    }

    public static Filter and(Iterable<Filter> filters) {
        return new LogicalFilter(Operator.zzaor, filters);
    }

    public static Filter or(Filter filter, Filter ... additionalFilters) {
        return new LogicalFilter(Operator.zzaos, filter, additionalFilters);
    }

    public static Filter or(Iterable<Filter> filters) {
        return new LogicalFilter(Operator.zzaos, filters);
    }

    public static Filter not(Filter toNegate) {
        return new NotFilter(toNegate);
    }

    public static Filter sharedWithMe() {
        return new FieldOnlyFilter(SearchableField.zzanQ);
    }

    public static Filter openedByMe() {
        return new FieldOnlyFilter(SearchableField.LAST_VIEWED_BY_ME);
    }

    public static Filter ownedByMe() {
        return new OwnedByMeFilter();
    }
}

