/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.widget;

import android.content.Context;
import android.database.CursorIndexOutOfBoundsException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.drive.internal.zzz;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DataBufferAdapter<T>
extends BaseAdapter {
    private final Context mContext;
    private final int zzapi;
    private int zzapj;
    private final int zzapk;
    private final List<DataBuffer<T>> zzapl;
    private final LayoutInflater mInflater;
    private boolean zzapm = true;

    public DataBufferAdapter(Context context, int resource, int textViewResourceId, List<DataBuffer<T>> objects) {
        this.mContext = context;
        this.zzapi = this.zzapj = resource;
        this.zzapk = textViewResourceId;
        this.zzapl = objects;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public DataBufferAdapter(Context context, int resource, int textViewResourceId) {
        this(context, resource, textViewResourceId, new ArrayList<DataBuffer<T>>());
    }

    public DataBufferAdapter(Context context, int resource, List<DataBuffer<T>> objects) {
        this(context, resource, 0, objects);
    }

    public DataBufferAdapter(Context context, int resource) {
        this(context, resource, 0, new ArrayList<DataBuffer<T>>());
    }

    public DataBufferAdapter(Context context, int resource, int textViewResourceId, DataBuffer<T> ... buffers) {
        this(context, resource, textViewResourceId, Arrays.asList(buffers));
    }

    public DataBufferAdapter(Context context, int resource, DataBuffer<T> ... buffers) {
        this(context, resource, 0, Arrays.asList(buffers));
    }

    public void append(DataBuffer<T> buffer) {
        this.zzapl.add(buffer);
        if (this.zzapm) {
            this.notifyDataSetChanged();
        }
    }

    public void clear() {
        for (DataBuffer<T> dataBuffer : this.zzapl) {
            dataBuffer.release();
        }
        this.zzapl.clear();
        if (this.zzapm) {
            this.notifyDataSetChanged();
        }
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.zzapm = true;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.zzapm = notifyOnChange;
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getCount() {
        int n = 0;
        for (DataBuffer<T> dataBuffer : this.zzapl) {
            n += dataBuffer.getCount();
        }
        return n;
    }

    public T getItem(int position) throws CursorIndexOutOfBoundsException {
        int n = position;
        for (DataBuffer<T> dataBuffer : this.zzapl) {
            int n2 = dataBuffer.getCount();
            if (n2 <= n) {
                n -= n2;
                continue;
            }
            try {
                return dataBuffer.get(n);
            }
            catch (CursorIndexOutOfBoundsException cursorIndexOutOfBoundsException) {
                throw new CursorIndexOutOfBoundsException(position, this.getCount());
            }
        }
        throw new CursorIndexOutOfBoundsException(position, this.getCount());
    }

    public long getItemId(int position) {
        return position;
    }

    private View zza(int n, View view, ViewGroup viewGroup, int n2) {
        TextView textView;
        View view2 = view == null ? this.mInflater.inflate(n2, viewGroup, false) : view;
        try {
            textView = this.zzapk == 0 ? (TextView)view2 : (TextView)view2.findViewById(this.zzapk);
        }
        catch (ClassCastException classCastException) {
            zzz.zza("DataBufferAdapter", classCastException, "You must supply a resource ID for a TextView");
            throw new IllegalStateException("DataBufferAdapter requires the resource ID to be a TextView", classCastException);
        }
        T t = this.getItem(n);
        if (t instanceof CharSequence) {
            textView.setText((CharSequence)t);
        } else {
            textView.setText((CharSequence)t.toString());
        }
        return view2;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.zza(position, convertView, parent, this.zzapi);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.zza(position, convertView, parent, this.zzapj);
    }

    public void setDropDownViewResource(int resource) {
        this.zzapj = resource;
    }
}

