/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
implements SafeParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int mVersionCode;
    private final long zzNY;
    private final long zzapN;
    private final Session zzapP;
    private final int zzapX;
    private final List<DataSet> zzapY;
    private final int zzapZ;
    private boolean zzaqa = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zzc();

    Bucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activityType, List<DataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.mVersionCode = versionCode;
        this.zzNY = startTimeMillis;
        this.zzapN = endTimeMillis;
        this.zzapP = session;
        this.zzapX = activityType;
        this.zzapY = dataSets;
        this.zzapZ = bucketType;
        this.zzaqa = serverHasMoreData;
    }

    public Bucket(RawBucket bucket, List<DataSource> uniqueDataSources) {
        this(2, bucket.zzNY, bucket.zzapN, bucket.zzapP, bucket.zzaqT, Bucket.zza(bucket.zzapY, uniqueDataSources), bucket.zzapZ, bucket.zzaqa);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzNY, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzapN, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzapP;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzapX);
    }

    public int zzsg() {
        return this.zzapX;
    }

    public List<DataSet> getDataSets() {
        return this.zzapY;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzapY) {
            if (!dataSet.getDataType().equals(dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzapZ;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Bucket && this.zza((Bucket)o);
    }

    private boolean zza(Bucket bucket) {
        return this.zzNY == bucket.zzNY && this.zzapN == bucket.zzapN && this.zzapX == bucket.zzapX && zzw.equal(this.zzapY, bucket.zzapY) && this.zzapZ == bucket.zzapZ && this.zzaqa == bucket.zzaqa;
    }

    public boolean zzb(Bucket bucket) {
        return this.zzNY == bucket.zzNY && this.zzapN == bucket.zzapN && this.zzapX == bucket.zzapX && this.zzapZ == bucket.zzapZ;
    }

    public boolean zzsh() {
        if (this.zzaqa) {
            return true;
        }
        for (DataSet dataSet : this.zzapY) {
            if (!dataSet.zzsh()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzNY, this.zzapN, this.zzapX, this.zzapZ);
    }

    public String toString() {
        return zzw.zzv(this).zzg("startTime", this.zzNY).zzg("endTime", this.zzapN).zzg("activity", this.zzapX).zzg("dataSets", this.zzapY).zzg("bucketType", Bucket.zzeu(this.zzapZ)).zzg("serverHasMoreData", this.zzaqa).toString();
    }

    public static String zzeu(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzkX() {
        return this.zzNY;
    }

    public long zzsi() {
        return this.zzapN;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }
}

