/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzd;
import com.google.android.gms.internal.zznj;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzapM;
    private long zzaqb;
    private long zzaqc;
    private final Value[] zzaqd;
    private DataSource zzaqe;
    private long zzaqf;
    private long zzaqg;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzd();

    DataPoint(int versionCode, DataSource dataSource, long timestampNanos, long startTimeNanos, Value[] values, DataSource originalDataSource, long rawTimestamp, long insertionTimeMillis) {
        this.mVersionCode = versionCode;
        this.zzapM = dataSource;
        this.zzaqe = originalDataSource;
        this.zzaqb = timestampNanos;
        this.zzaqc = startTimeNanos;
        this.zzaqd = values;
        this.zzaqf = rawTimestamp;
        this.zzaqg = insertionTimeMillis;
    }

    DataPoint(List<DataSource> dataSources, RawDataPoint rawDataPoint) {
        this(DataPoint.zza(dataSources, rawDataPoint.zzaqU), DataPoint.zza(dataSources, rawDataPoint.zzaqV), rawDataPoint);
    }

    public DataPoint(DataSource dataSource, DataSource originalDataSource, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzaqb, 0L), DataPoint.zza(rawDataPoint.zzaqc, 0L), rawDataPoint.zzaqd, originalDataSource, DataPoint.zza(rawDataPoint.zzaqf, 0L), DataPoint.zza(rawDataPoint.zzaqg, 0L));
    }

    private static DataSource zza(List<DataSource> list, int n) {
        return n >= 0 && n < list.size() ? list.get(n) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.mVersionCode = 4;
        this.zzapM = zzx.zzb(dataSource, (Object)"Data source cannot be null");
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.zzaqd = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzaqd[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return zzc.zza(intent, "com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long timestamp, TimeUnit timeUnit) {
        this.zzaqb = timeUnit.toNanos(timestamp);
        if (this.zzsj() && zznj.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzaqb = zznj.zza(this.zzaqb, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean zzsj() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
        this.zzaqc = timeUnit.toNanos(startTime);
        this.zzaqb = timeUnit.toNanos(endTime);
        return this;
    }

    public Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzaqd[n];
    }

    public Value[] zzsk() {
        return this.zzaqd;
    }

    public DataPoint setFloatValues(float ... values) {
        this.zzew(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzaqd[i].setFloat(values[i]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... values) {
        this.zzew(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzaqd[i].setInt(values[i]);
        }
        return this;
    }

    private void zzew(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzx.zzb(n == n2, "Attempting to insert %s values, but needed %s: %s", n, n2, list);
    }

    public DataType getDataType() {
        return this.zzapM.getDataType();
    }

    public DataSource getDataSource() {
        return this.zzapM;
    }

    public DataSource getOriginalDataSource() {
        return this.zzaqe;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaqb, TimeUnit.NANOSECONDS);
    }

    public long zzsl() {
        return this.zzaqf;
    }

    public long zzsm() {
        return this.zzaqg;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaqc, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaqb, TimeUnit.NANOSECONDS);
    }

    public void zzsn() {
        DataSource dataSource = this.getDataSource();
        zzx.zzb(this.getDataType().getName().equals(dataSource.getDataType().getName()), "Conflicting data types found %s vs %s", this.getDataType(), this.getDataType());
        zzx.zzb(this.zzaqb > 0L, "Data point does not have the timestamp set: %s", this);
        zzx.zzb(this.zzaqc <= this.zzaqb, "Data point with start time greater than end time found: %s", this);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof DataPoint && this.zza((DataPoint)o);
    }

    private boolean zza(DataPoint dataPoint) {
        return zzw.equal(this.zzapM, dataPoint.zzapM) && this.zzaqb == dataPoint.zzaqb && this.zzaqc == dataPoint.zzaqc && Arrays.equals(this.zzaqd, dataPoint.zzaqd) && zzw.equal(this.zzaqe, dataPoint.zzaqe);
    }

    public int hashCode() {
        return zzw.hashCode(this.zzapM, this.zzaqb, this.zzaqc);
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString(this.zzaqd), this.zzaqc, this.zzaqb, this.zzaqf, this.zzaqg, this.zzapM.toDebugString(), this.zzaqe != null ? this.zzaqe.toDebugString() : "N/A");
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public long getTimestampNanos() {
        return this.zzaqb;
    }

    public long zzso() {
        return this.zzaqc;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzd.zza(this, parcel, flags);
    }

    private static long zza(Long l2, long l3) {
        return l2 != null ? l2 : l3;
    }
}

