/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataSet
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzapM;
    private final DataType zzapL;
    private final List<DataPoint> zzaqh;
    private final List<DataSource> zzaqi;
    private boolean zzaqa = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zze();

    DataSet(int versionCode, DataSource dataSource, DataType dataType, List<RawDataPoint> dataPoints, List<DataSource> uniqueDataSources, boolean serverHasMoreData) {
        this.mVersionCode = versionCode;
        this.zzapM = dataSource;
        this.zzapL = dataSource.getDataType();
        this.zzaqa = serverHasMoreData;
        this.zzaqh = new ArrayList<DataPoint>(dataPoints.size());
        this.zzaqi = versionCode >= 2 ? uniqueDataSources : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : dataPoints) {
            this.zzaqh.add(new DataPoint(this.zzaqi, rawDataPoint));
        }
    }

    public DataSet(DataSource dataSource) {
        this.mVersionCode = 3;
        this.zzapM = zzx.zzw(dataSource);
        this.zzapL = dataSource.getDataType();
        this.zzaqh = new ArrayList<DataPoint>();
        this.zzaqi = new ArrayList<DataSource>();
        this.zzaqi.add(this.zzapM);
    }

    public DataSet(RawDataSet dataSet, List<DataSource> uniqueDataSources) {
        this.mVersionCode = 3;
        this.zzapM = DataSet.zzb(uniqueDataSources, dataSet.zzaqU);
        this.zzapL = this.zzapM.getDataType();
        this.zzaqi = uniqueDataSources;
        this.zzaqa = dataSet.zzaqa;
        List<RawDataPoint> list = dataSet.zzaqX;
        this.zzaqh = new ArrayList<DataPoint>(list.size());
        for (RawDataPoint rawDataPoint : list) {
            this.zzaqh.add(new DataPoint(this.zzaqi, rawDataPoint));
        }
    }

    private static <T> T zzb(List<T> list, int n) {
        return n >= 0 && n < list.size() ? (T)list.get(n) : null;
    }

    public static DataSet create(DataSource dataSource) {
        zzx.zzb(dataSource, (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.zzapM);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzx.zzb(dataSource.getStreamIdentifier().equals(this.zzapM.getStreamIdentifier()), "Conflicting data sources found %s vs %s", dataSource, this.zzapM);
        dataPoint.zzsn();
        this.zzb(dataPoint);
    }

    public void zzb(DataPoint dataPoint) {
        this.zzaqh.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzaqi.contains(dataSource)) {
            this.zzaqi.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> dataPoints) {
        for (DataPoint dataPoint : dataPoints) {
            this.add(dataPoint);
        }
    }

    public void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zzb(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.zzapM;
    }

    public DataType getDataType() {
        return this.zzapM.getDataType();
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzaqh);
    }

    public boolean isEmpty() {
        return this.zzaqh.isEmpty();
    }

    public boolean zzsh() {
        return this.zzaqa;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataSet && this.zza((DataSet)o);
    }

    private boolean zza(DataSet dataSet) {
        return zzw.equal(this.getDataType(), dataSet.getDataType()) && zzw.equal(this.zzapM, dataSet.zzapM) && zzw.equal(this.zzaqh, dataSet.zzaqh) && this.zzaqa == dataSet.zzaqa;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzapM);
    }

    public String toString() {
        List<RawDataPoint> list = this.zzsp();
        return String.format("DataSet{%s %s}", this.zzapM.toDebugString(), this.zzaqh.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzaqh.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List<RawDataPoint> zzsp() {
        return this.zzr(this.zzaqi);
    }

    List<RawDataPoint> zzr(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzaqh.size());
        for (DataPoint dataPoint : this.zzaqh) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> zzsq() {
        return this.zzaqi;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zze.zza(this, parcel, flags);
    }
}

