/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zznk;
import com.google.android.gms.internal.zzom;

public final class Device
implements SafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    private final int mVersionCode;
    private final String zzaqx;
    private final String zzaqy;
    private final String zzYk;
    private final String zzaqz;
    private final int zzWJ;
    private final int zzaqA;
    public static final Parcelable.Creator<Device> CREATOR = new zzh();

    public static Device getLocalDevice(Context context) {
        int n = zznk.zzax(context);
        String string2 = Device.zzat(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string2, n, 2);
    }

    private static String zzat(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public Device(String manufacturer, String model, String uid, int type) {
        this(manufacturer, model, "", uid, type, 0);
    }

    public Device(String manufacturer, String model, String version, String uid, int type, int platformType) {
        this(1, manufacturer, model, "", uid, type, platformType);
    }

    Device(int versionCode, String manufacturer, String model, String version, String uid, int type, int platformType) {
        this.mVersionCode = versionCode;
        this.zzaqx = zzx.zzw(manufacturer);
        this.zzaqy = zzx.zzw(model);
        this.zzYk = "";
        this.zzaqz = zzx.zzw(uid);
        this.zzWJ = type;
        this.zzaqA = platformType;
    }

    public String getManufacturer() {
        return this.zzaqx;
    }

    public String getModel() {
        return this.zzaqy;
    }

    public String getVersion() {
        return this.zzYk;
    }

    public String getUid() {
        return this.zzaqz;
    }

    public int getType() {
        return this.zzWJ;
    }

    public int zzsu() {
        return this.zzaqA;
    }

    private boolean zzsv() {
        return this.zzsu() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzaqx, this.zzaqy, this.zzaqz);
    }

    public String zzsw() {
        return this.zzsv() ? this.zzaqz : zzom.zzcU(this.zzaqz);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.zzYk, this.zzWJ, this.zzaqA);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Device && this.zza((Device)that);
    }

    private boolean zza(Device device) {
        return zzw.equal(this.zzaqx, device.zzaqx) && zzw.equal(this.zzaqy, device.zzaqy) && zzw.equal(this.zzYk, device.zzYk) && zzw.equal(this.zzaqz, device.zzaqz) && this.zzWJ == device.zzWJ && this.zzaqA == device.zzaqA;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzaqx, this.zzaqy, this.zzYk, this.zzaqz, this.zzWJ);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzh.zza(this, parcel, flags);
    }
}

