/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzm;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawBucket
implements SafeParcelable {
    final int mVersionCode;
    public final long zzNY;
    public final long zzapN;
    public final Session zzapP;
    public final int zzaqT;
    public final List<RawDataSet> zzapY;
    public final int zzapZ;
    public final boolean zzaqa;
    public static final Parcelable.Creator<RawBucket> CREATOR = new zzm();

    public RawBucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<RawDataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.mVersionCode = versionCode;
        this.zzNY = startTimeMillis;
        this.zzapN = endTimeMillis;
        this.zzapP = session;
        this.zzaqT = activity;
        this.zzapY = dataSets;
        this.zzapZ = bucketType;
        this.zzaqa = serverHasMoreData;
    }

    public RawBucket(Bucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.mVersionCode = 2;
        this.zzNY = bucket.getStartTime(TimeUnit.MILLISECONDS);
        this.zzapN = bucket.getEndTime(TimeUnit.MILLISECONDS);
        this.zzapP = bucket.getSession();
        this.zzaqT = bucket.zzsg();
        this.zzapZ = bucket.getBucketType();
        this.zzaqa = bucket.zzsh();
        List<DataSet> list = bucket.getDataSets();
        this.zzapY = new ArrayList<RawDataSet>(list.size());
        for (DataSet dataSet : list) {
            this.zzapY.add(new RawDataSet(dataSet, uniqueDataSources, uniqueDataTypes));
        }
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RawBucket && this.zza((RawBucket)o);
    }

    private boolean zza(RawBucket rawBucket) {
        return this.zzNY == rawBucket.zzNY && this.zzapN == rawBucket.zzapN && this.zzaqT == rawBucket.zzaqT && zzw.equal(this.zzapY, rawBucket.zzapY) && this.zzapZ == rawBucket.zzapZ && this.zzaqa == rawBucket.zzaqa;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzNY, this.zzapN, this.zzapZ);
    }

    public String toString() {
        return zzw.zzv(this).zzg("startTime", this.zzNY).zzg("endTime", this.zzapN).zzg("activity", this.zzaqT).zzg("dataSets", this.zzapY).zzg("bucketType", this.zzapZ).zzg("serverHasMoreData", this.zzaqa).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzm.zza(this, parcel, flags);
    }
}

