/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzn;
import com.google.android.gms.fitness.data.zzs;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawDataPoint
implements SafeParcelable {
    final int mVersionCode;
    public final long zzaqb;
    public final long zzaqc;
    public final Value[] zzaqd;
    public final int zzaqU;
    public final int zzaqV;
    public final long zzaqf;
    public final long zzaqg;
    public static final Parcelable.Creator<RawDataPoint> CREATOR = new zzn();

    public RawDataPoint(int versionCode, long timestampNanos, long startTimeNanos, Value[] values, int dataSourceIndex, int originalDataSourceIndex, long rawTimestamp, long insertionTimeMillis) {
        this.mVersionCode = versionCode;
        this.zzaqb = timestampNanos;
        this.zzaqc = startTimeNanos;
        this.zzaqU = dataSourceIndex;
        this.zzaqV = originalDataSourceIndex;
        this.zzaqf = rawTimestamp;
        this.zzaqg = insertionTimeMillis;
        this.zzaqd = values;
    }

    RawDataPoint(DataPoint dataPoint, List<DataSource> dataSources) {
        this.mVersionCode = 4;
        this.zzaqb = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
        this.zzaqc = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
        this.zzaqd = dataPoint.zzsk();
        this.zzaqU = zzs.zza(dataPoint.getDataSource(), dataSources);
        this.zzaqV = zzs.zza(dataPoint.getOriginalDataSource(), dataSources);
        this.zzaqf = dataPoint.zzsl();
        this.zzaqg = dataPoint.zzsm();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RawDataPoint && this.zza((RawDataPoint)o);
    }

    private boolean zza(RawDataPoint rawDataPoint) {
        return this.zzaqb == rawDataPoint.zzaqb && this.zzaqc == rawDataPoint.zzaqc && Arrays.equals(this.zzaqd, rawDataPoint.zzaqd) && this.zzaqU == rawDataPoint.zzaqU && this.zzaqV == rawDataPoint.zzaqV && this.zzaqf == rawDataPoint.zzaqf;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzaqb, this.zzaqc);
    }

    public String toString() {
        return String.format("RawDataPoint{%s@[%s, %s](%d,%d)}", Arrays.toString(this.zzaqd), this.zzaqc, this.zzaqb, this.zzaqU, this.zzaqV);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzn.zza(this, parcel, flags);
    }
}

