/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzd;
import com.google.android.gms.internal.zzoj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final long zzNY;
    private final long zzapN;
    private final List<DataSource> zzasd;
    private final List<DataType> zzapW;
    private final List<Session> zzase;
    private final boolean zzasf;
    private final boolean zzasg;
    private final zzoj zzasb;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzd();

    DataDeleteRequest(int versionCode, long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzNY = startTimeMillis;
        this.zzapN = endTimeMillis;
        this.zzasd = Collections.unmodifiableList(dataSources);
        this.zzapW = Collections.unmodifiableList(dataTypes);
        this.zzase = sessions;
        this.zzasf = deleteAllData;
        this.zzasg = deleteAllSessions;
        this.zzasb = zzoj.zza.zzbJ(callback);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzNY, builder.zzapN, builder.zzasd, builder.zzapW, builder.zzase, builder.zzasf, builder.zzasg, null);
    }

    public DataDeleteRequest(DataDeleteRequest request, zzoj callback) {
        this(request.zzNY, request.zzapN, request.zzasd, request.zzapW, request.zzase, request.zzasf, request.zzasg, callback);
    }

    public DataDeleteRequest(long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, zzoj callback) {
        this.mVersionCode = 3;
        this.zzNY = startTimeMillis;
        this.zzapN = endTimeMillis;
        this.zzasd = Collections.unmodifiableList(dataSources);
        this.zzapW = Collections.unmodifiableList(dataTypes);
        this.zzase = sessions;
        this.zzasf = deleteAllData;
        this.zzasg = deleteAllSessions;
        this.zzasb = callback;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzNY, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzapN, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzasd;
    }

    public List<DataType> getDataTypes() {
        return this.zzapW;
    }

    public List<Session> getSessions() {
        return this.zzase;
    }

    public boolean deleteAllData() {
        return this.zzasf;
    }

    public boolean deleteAllSessions() {
        return this.zzasg;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataDeleteRequest && this.zzb((DataDeleteRequest)o);
    }

    private boolean zzb(DataDeleteRequest dataDeleteRequest) {
        return this.zzNY == dataDeleteRequest.zzNY && this.zzapN == dataDeleteRequest.zzapN && zzw.equal(this.zzasd, dataDeleteRequest.zzasd) && zzw.equal(this.zzapW, dataDeleteRequest.zzapW) && zzw.equal(this.zzase, dataDeleteRequest.zzase) && this.zzasf == dataDeleteRequest.zzasf && this.zzasg == dataDeleteRequest.zzasg;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzNY, this.zzapN);
    }

    public String toString() {
        return zzw.zzv(this).zzg("startTimeMillis", this.zzNY).zzg("endTimeMillis", this.zzapN).zzg("dataSources", this.zzasd).zzg("dateTypes", this.zzapW).zzg("sessions", this.zzase).zzg("deleteAllData", this.zzasf).zzg("deleteAllSessions", this.zzasg).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean zzsP() {
        return this.zzasf;
    }

    public boolean zzsQ() {
        return this.zzasg;
    }

    public long zzsi() {
        return this.zzapN;
    }

    public long zzkX() {
        return this.zzNY;
    }

    public IBinder zzsO() {
        return this.zzasb == null ? null : this.zzasb.asBinder();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzd.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzNY;
        private long zzapN;
        private List<DataSource> zzasd = new ArrayList<DataSource>();
        private List<DataType> zzapW = new ArrayList<DataType>();
        private List<Session> zzase = new ArrayList<Session>();
        private boolean zzasf = false;
        private boolean zzasg = false;

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            zzx.zzb(startTime > 0L, "Invalid start time :%d", startTime);
            zzx.zzb(endTime > startTime, "Invalid end time :%d", endTime);
            this.zzNY = timeUnit.toMillis(startTime);
            this.zzapN = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder deleteAllData() {
            zzx.zzb(this.zzapW.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzx.zzb(this.zzasd.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzasf = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzx.zzb(!this.zzasf, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzx.zzb(dataType != null, (Object)"Must specify a valid data type");
            if (!this.zzapW.contains(dataType)) {
                this.zzapW.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzx.zzb(!this.zzasf, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzx.zzb(dataSource != null, (Object)"Must specify a valid data source");
            if (!this.zzasd.contains(dataSource)) {
                this.zzasd.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzx.zzb(!this.zzasg, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzx.zzb(session != null, (Object)"Must specify a valid session");
            zzx.zzb(session.getEndTime(TimeUnit.MILLISECONDS) > 0L, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzase.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzx.zzb(this.zzase.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzasg = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzx.zza(this.zzNY > 0L && this.zzapN > this.zzNY, (Object)"Must specify a valid time interval");
            boolean bl = this.zzasf || !this.zzasd.isEmpty() || !this.zzapW.isEmpty();
            boolean bl2 = this.zzasg || !this.zzase.isEmpty();
            zzx.zza(bl || bl2, (Object)"No data or session marked for deletion");
            this.zzsR();
            return new DataDeleteRequest(this);
        }

        private void zzsR() {
            if (this.zzase.isEmpty()) {
                return;
            }
            for (Session session : this.zzase) {
                zzx.zza(session.getStartTime(TimeUnit.MILLISECONDS) >= this.zzNY && session.getEndTime(TimeUnit.MILLISECONDS) <= this.zzapN, "Session %s is outside the time interval [%d, %d]", session, this.zzNY, this.zzapN);
            }
        }
    }
}

