/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzh;
import com.google.android.gms.internal.zzmj;
import com.google.android.gms.internal.zznv;
import java.util.Arrays;
import java.util.List;

public class DataSourcesRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final List<DataType> zzapW;
    private final List<Integer> zzast;
    private final boolean zzasu;
    private final zznv zzasv;
    public static final Parcelable.Creator<DataSourcesRequest> CREATOR = new zzh();

    DataSourcesRequest(int versionCode, List<DataType> dataTypes, List<Integer> dataSourceTypes, boolean includeDbOnlySources, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzapW = dataTypes;
        this.zzast = dataSourceTypes;
        this.zzasu = includeDbOnlySources;
        this.zzasv = zznv.zza.zzbv(callback);
    }

    private DataSourcesRequest(Builder builder) {
        this(zzmj.zzb(builder.zzasw), Arrays.asList(zzmj.zza(builder.zzasx)), builder.zzasu, null);
    }

    public DataSourcesRequest(DataSourcesRequest request, zznv callback) {
        this(request.zzapW, request.zzast, request.zzasu, callback);
    }

    public DataSourcesRequest(List<DataType> dataTypes, List<Integer> dataSourceTypes, boolean includeDbOnlySources, zznv callback) {
        this.mVersionCode = 4;
        this.zzapW = dataTypes;
        this.zzast = dataSourceTypes;
        this.zzasu = includeDbOnlySources;
        this.zzasv = callback;
    }

    public List<DataType> getDataTypes() {
        return this.zzapW;
    }

    public List<Integer> zzsX() {
        return this.zzast;
    }

    public boolean zzsY() {
        return this.zzasu;
    }

    public IBinder zzsO() {
        return this.zzasv == null ? null : this.zzasv.asBinder();
    }

    public String toString() {
        zzw.zza zza2 = zzw.zzv(this).zzg("dataTypes", this.zzapW).zzg("sourceTypes", this.zzast);
        if (this.zzasu) {
            zza2.zzg("includeDbOnlySources", "true");
        }
        return zza2.toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzh.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzasw = new DataType[0];
        private int[] zzasx = new int[]{0, 1};
        private boolean zzasu = false;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzasw = dataTypes;
            return this;
        }

        public Builder setDataSourceTypes(int ... dataSourceTypes) {
            this.zzasx = dataSourceTypes;
            return this;
        }

        public DataSourcesRequest build() {
            zzx.zza(this.zzasw.length > 0, (Object)"Must add at least one data type");
            zzx.zza(this.zzasx.length > 0, (Object)"Must add at least one data source type");
            return new DataSourcesRequest(this);
        }
    }
}

