/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzu;
import com.google.android.gms.internal.zznj;
import com.google.android.gms.internal.zzoj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final Session zzapP;
    private final List<DataSet> zzapY;
    private final List<DataPoint> zzasQ;
    private final zzoj zzasb;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzu();

    SessionInsertRequest(int versionCode, Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzapP = session;
        this.zzapY = Collections.unmodifiableList(dataSets);
        this.zzasQ = Collections.unmodifiableList(aggregateDataPoints);
        this.zzasb = zzoj.zza.zzbJ(callback);
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzapP, builder.zzapY, builder.zzasQ, null);
    }

    public SessionInsertRequest(SessionInsertRequest request, zzoj callback) {
        this(request.zzapP, request.zzapY, request.zzasQ, callback);
    }

    public SessionInsertRequest(Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, zzoj callback) {
        this.mVersionCode = 3;
        this.zzapP = session;
        this.zzapY = Collections.unmodifiableList(dataSets);
        this.zzasQ = Collections.unmodifiableList(aggregateDataPoints);
        this.zzasb = callback;
    }

    public Session getSession() {
        return this.zzapP;
    }

    public List<DataSet> getDataSets() {
        return this.zzapY;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzasQ;
    }

    public IBinder zzsO() {
        return this.zzasb == null ? null : this.zzasb.asBinder();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SessionInsertRequest && this.zzb((SessionInsertRequest)o);
    }

    private boolean zzb(SessionInsertRequest sessionInsertRequest) {
        return zzw.equal(this.zzapP, sessionInsertRequest.zzapP) && zzw.equal(this.zzapY, sessionInsertRequest.zzapY) && zzw.equal(this.zzasQ, sessionInsertRequest.zzasQ);
    }

    public int hashCode() {
        return zzw.hashCode(this.zzapP, this.zzapY, this.zzasQ);
    }

    public String toString() {
        return zzw.zzv(this).zzg("session", this.zzapP).zzg("dataSets", this.zzapY).zzg("aggregateDataPoints", this.zzasQ).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzu.zza(this, dest, flags);
    }

    public static class Builder {
        private Session zzapP;
        private List<DataSet> zzapY = new ArrayList<DataSet>();
        private List<DataPoint> zzasQ = new ArrayList<DataPoint>();
        private List<DataSource> zzasR = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.zzapP = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzx.zzb(dataSet != null, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzx.zza(!this.zzasR.contains(dataSource), "Data set for this data source %s is already added.", dataSource);
            List<DataPoint> list = dataSet.getDataPoints();
            zzx.zzb(!list.isEmpty(), (Object)"No data points specified in the input data set.");
            this.zzasR.add(dataSource);
            this.zzapY.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint aggregateDataPoint) {
            zzx.zzb(aggregateDataPoint != null, (Object)"Must specify a valid aggregate data point.");
            long l2 = aggregateDataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l3 = aggregateDataPoint.getEndTime(TimeUnit.NANOSECONDS);
            zzx.zzb(l2 > 0L && l3 > l2, "Aggregate data point should have valid start and end times: %s", aggregateDataPoint);
            DataSource dataSource = aggregateDataPoint.getDataSource();
            zzx.zza(!this.zzasR.contains(dataSource), "Data set/Aggregate data point for this data source %s is already added.", dataSource);
            this.zzasR.add(dataSource);
            this.zzasQ.add(aggregateDataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzx.zza(this.zzapP != null, (Object)"Must specify a valid session.");
            zzx.zza(this.zzapP.getEndTime(TimeUnit.MILLISECONDS) != 0L, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.zzth();
            return new SessionInsertRequest(this);
        }

        private void zzd(DataPoint dataPoint) {
            this.zzf(dataPoint);
            this.zze(dataPoint);
        }

        private void zze(DataPoint dataPoint) {
            long l2 = this.zzapP.getStartTime(TimeUnit.NANOSECONDS);
            long l3 = this.zzapP.getEndTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l5 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l4 != 0L && l5 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l5 > l3) {
                    l5 = zznj.zza(l5, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzx.zza(l4 >= l2 && l5 <= l3, "Data point %s has start and end times outside session interval [%d, %d]", dataPoint, l2, l3);
                if (l5 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l5, timeUnit}));
                    dataPoint.setTimeInterval(l4, l5, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzf(DataPoint dataPoint) {
            long l2 = this.zzapP.getStartTime(TimeUnit.NANOSECONDS);
            long l3 = this.zzapP.getEndTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 < l2 || l4 > l3) {
                    l4 = zznj.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzx.zza(l4 >= l2 && l4 <= l3, "Data point %s has time stamp outside session interval [%d, %d]", dataPoint, l2, l3);
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l4) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimestamp(l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzth() {
            for (DataSet safeParcelable : this.zzapY) {
                for (DataPoint dataPoint : safeParcelable.getDataPoints()) {
                    this.zzd(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.zzasQ) {
                this.zzd(dataPoint);
            }
        }
    }
}

