/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzv;
import com.google.android.gms.internal.zzoh;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final String zzasS;
    private final String zzHP;
    private final long zzNY;
    private final long zzapN;
    private final List<DataType> zzapW;
    private final List<DataSource> zzasd;
    private boolean zzasT;
    private final boolean zzaso;
    private final List<String> zzasU;
    private final zzoh zzasV;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzv();

    SessionReadRequest(int versionCode, String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzasS = sessionName;
        this.zzHP = sessionId;
        this.zzNY = startTimeMillis;
        this.zzapN = endTimeMillis;
        this.zzapW = dataTypes;
        this.zzasd = dataSources;
        this.zzasT = getSessionsFromAllApps;
        this.zzaso = serverQueriesEnabled;
        this.zzasU = excludedPackages;
        this.zzasV = zzoh.zza.zzbH(callback);
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzasS, builder.zzHP, builder.zzNY, builder.zzapN, builder.zzapW, builder.zzasd, builder.zzasT, builder.zzaso, builder.zzasU, null);
    }

    public SessionReadRequest(SessionReadRequest request, zzoh callback) {
        this(request.zzasS, request.zzHP, request.zzNY, request.zzapN, request.zzapW, request.zzasd, request.zzasT, request.zzaso, request.zzasU, callback);
    }

    public SessionReadRequest(String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages, zzoh callback) {
        this(5, sessionName, sessionId, startTimeMillis, endTimeMillis, dataTypes, dataSources, getSessionsFromAllApps, serverQueriesEnabled, excludedPackages, callback == null ? null : callback.asBinder());
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzNY, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzapN, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzasS;
    }

    public String getSessionId() {
        return this.zzHP;
    }

    public List<DataType> getDataTypes() {
        return this.zzapW;
    }

    public List<DataSource> getDataSources() {
        return this.zzasd;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzasT;
    }

    public List<String> getExcludedPackages() {
        return this.zzasU;
    }

    public boolean zzsT() {
        return this.zzaso;
    }

    public long zzsi() {
        return this.zzapN;
    }

    public long zzkX() {
        return this.zzNY;
    }

    public boolean zzti() {
        return this.zzasT;
    }

    public IBinder zzsO() {
        return this.zzasV == null ? null : this.zzasV.asBinder();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof SessionReadRequest && this.zzb((SessionReadRequest)o);
    }

    private boolean zzb(SessionReadRequest sessionReadRequest) {
        return zzw.equal(this.zzasS, sessionReadRequest.zzasS) && this.zzHP.equals(sessionReadRequest.zzHP) && this.zzNY == sessionReadRequest.zzNY && this.zzapN == sessionReadRequest.zzapN && zzw.equal(this.zzapW, sessionReadRequest.zzapW) && zzw.equal(this.zzasd, sessionReadRequest.zzasd) && this.zzasT == sessionReadRequest.zzasT && this.zzasU.equals(sessionReadRequest.zzasU) && this.zzaso == sessionReadRequest.zzaso;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzasS, this.zzHP, this.zzNY, this.zzapN);
    }

    public String toString() {
        return zzw.zzv(this).zzg("sessionName", this.zzasS).zzg("sessionId", this.zzHP).zzg("startTimeMillis", this.zzNY).zzg("endTimeMillis", this.zzapN).zzg("dataTypes", this.zzapW).zzg("dataSources", this.zzasd).zzg("sessionsFromAllApps", this.zzasT).zzg("excludedPackages", this.zzasU).zzg("useServer", this.zzaso).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzv.zza(this, dest, flags);
    }

    public static class Builder {
        private String zzasS;
        private String zzHP;
        private long zzNY = 0L;
        private long zzapN = 0L;
        private List<DataType> zzapW = new ArrayList<DataType>();
        private List<DataSource> zzasd = new ArrayList<DataSource>();
        private boolean zzasT = false;
        private boolean zzaso = false;
        private List<String> zzasU = new ArrayList<String>();

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            this.zzNY = timeUnit.toMillis(startTime);
            this.zzapN = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder setSessionName(String sessionName) {
            this.zzasS = sessionName;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.zzHP = sessionId;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzx.zzb(dataSource, (Object)"Attempting to add a null data source");
            if (!this.zzasd.contains(dataSource)) {
                this.zzasd.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzx.zzb(dataType, (Object)"Attempting to use a null data type");
            if (!this.zzapW.contains(dataType)) {
                this.zzapW.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzasT = true;
            return this;
        }

        public Builder excludePackage(String appPackageName) {
            zzx.zzb(appPackageName, (Object)"Attempting to use a null package name");
            if (!this.zzasU.contains(appPackageName)) {
                this.zzasU.add(appPackageName);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaso = true;
            return this;
        }

        public SessionReadRequest build() {
            zzx.zzb(this.zzNY > 0L, "Invalid start time: %s", this.zzNY);
            zzx.zzb(this.zzapN > 0L && this.zzapN > this.zzNY, "Invalid end time: %s", this.zzapN);
            return new SessionReadRequest(this);
        }
    }
}

