/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
implements Result,
SafeParcelable {
    private final int mVersionCode;
    private final List<DataSet> zzapY;
    private final Status zzSC;
    private final List<Bucket> zzatd;
    private int zzate;
    private final List<DataSource> zzaqi;
    private final List<DataType> zzatf;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(int versionCode, List<RawDataSet> dataSets, Status status, List<RawBucket> buckets, int batchCount, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.mVersionCode = versionCode;
        this.zzSC = status;
        this.zzate = batchCount;
        this.zzaqi = uniqueDataSources;
        this.zzatf = uniqueDataTypes;
        this.zzapY = new ArrayList<DataSet>(dataSets.size());
        for (RawDataSet safeParcelable : dataSets) {
            this.zzapY.add(new DataSet(safeParcelable, uniqueDataSources));
        }
        this.zzatd = new ArrayList<Bucket>(buckets.size());
        for (RawBucket rawBucket : buckets) {
            this.zzatd.add(new Bucket(rawBucket, uniqueDataSources));
        }
    }

    public DataReadResult(List<DataSet> dataSets, List<Bucket> buckets, Status status) {
        this.mVersionCode = 5;
        this.zzapY = dataSets;
        this.zzSC = status;
        this.zzatd = buckets;
        this.zzate = 1;
        this.zzaqi = new ArrayList<DataSource>();
        this.zzatf = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource safeParcelable : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(safeParcelable));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzapY) {
            if (!dataType.equals(dataSet.getDataType())) continue;
            return dataSet;
        }
        return DataSet.create(new DataSource.Builder().setDataType(dataType).setType(1).build());
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzapY) {
            if (!dataSource.equals(dataSet.getDataSource())) continue;
            return dataSet;
        }
        return DataSet.create(dataSource);
    }

    public List<DataSet> getDataSets() {
        return this.zzapY;
    }

    public List<Bucket> getBuckets() {
        return this.zzatd;
    }

    public int zztn() {
        return this.zzate;
    }

    public void zzb(DataReadResult dataReadResult) {
        for (DataSet safeParcelable : dataReadResult.getDataSets()) {
            this.zza(safeParcelable, this.zzapY);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.zza(bucket, this.zzatd);
        }
    }

    private void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals(dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void zza(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.zzb(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.zza(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.zzatd.add(bucket);
    }

    @Override
    public Status getStatus() {
        return this.zzSC;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadResult && this.zzc((DataReadResult)that);
    }

    private boolean zzc(DataReadResult dataReadResult) {
        return this.zzSC.equals(dataReadResult.zzSC) && zzw.equal(this.zzapY, dataReadResult.zzapY) && zzw.equal(this.zzatd, dataReadResult.zzatd);
    }

    public int hashCode() {
        return zzw.hashCode(this.zzSC, this.zzapY, this.zzatd);
    }

    public String toString() {
        return zzw.zzv(this).zzg("status", this.zzSC).zzg("dataSets", this.zzapY.size() > 5 ? this.zzapY.size() + " data sets" : this.zzapY).zzg("buckets", this.zzatd.size() > 5 ? this.zzatd.size() + " buckets" : this.zzatd).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List<RawBucket> zzto() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzatd.size());
        for (Bucket bucket : this.zzatd) {
            arrayList.add(new RawBucket(bucket, this.zzaqi, this.zzatf));
        }
        return arrayList;
    }

    List<RawDataSet> zztp() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.zzapY.size());
        for (DataSet dataSet : this.zzapY) {
            arrayList.add(new RawDataSet(dataSet, this.zzaqi, this.zzatf));
        }
        return arrayList;
    }

    List<DataSource> zzsq() {
        return this.zzaqi;
    }

    List<DataType> zztq() {
        return this.zzatf;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }
}

