/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Subscription;
import com.google.android.gms.fitness.result.zzh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListSubscriptionsResult
implements Result,
SafeParcelable {
    private final int mVersionCode;
    private final List<Subscription> zzatk;
    private final Status zzSC;
    public static final Parcelable.Creator<ListSubscriptionsResult> CREATOR = new zzh();

    ListSubscriptionsResult(int versionCode, List<Subscription> subscriptions, Status status) {
        this.mVersionCode = versionCode;
        this.zzatk = subscriptions;
        this.zzSC = status;
    }

    public ListSubscriptionsResult(List<Subscription> subscriptions, Status status) {
        this.mVersionCode = 3;
        this.zzatk = Collections.unmodifiableList(subscriptions);
        this.zzSC = zzx.zzb(status, (Object)"status");
    }

    public static ListSubscriptionsResult zzS(Status status) {
        return new ListSubscriptionsResult(Collections.emptyList(), status);
    }

    public List<Subscription> getSubscriptions() {
        return this.zzatk;
    }

    public List<Subscription> getSubscriptions(DataType dataType) {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        for (Subscription subscription : this.zzatk) {
            if (!dataType.equals(subscription.zzsC())) continue;
            arrayList.add(subscription);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Status getStatus() {
        return this.zzSC;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ListSubscriptionsResult && this.zzb((ListSubscriptionsResult)that);
    }

    private boolean zzb(ListSubscriptionsResult listSubscriptionsResult) {
        return this.zzSC.equals(listSubscriptionsResult.zzSC) && zzw.equal(this.zzatk, listSubscriptionsResult.zzatk);
    }

    public int hashCode() {
        return zzw.hashCode(this.zzSC, this.zzatk);
    }

    public String toString() {
        return zzw.zzv(this).zzg("status", this.zzSC).zzg("subscriptions", this.zzatk).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzh.zza(this, dest, flags);
    }
}

