/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.SessionDataSet;
import com.google.android.gms.fitness.result.zzj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
implements Result,
SafeParcelable {
    private final int mVersionCode;
    private final List<Session> zzase;
    private final List<SessionDataSet> zzatm;
    private final Status zzSC;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzj();

    SessionReadResult(int versionCode, List<Session> sessions, List<SessionDataSet> sessionDataSets, Status status) {
        this.mVersionCode = versionCode;
        this.zzase = sessions;
        this.zzatm = Collections.unmodifiableList(sessionDataSets);
        this.zzSC = status;
    }

    public SessionReadResult(List<Session> sessions, List<SessionDataSet> sessionDataSets, Status status) {
        this.mVersionCode = 3;
        this.zzase = sessions;
        this.zzatm = Collections.unmodifiableList(sessionDataSets);
        this.zzSC = status;
    }

    public static SessionReadResult zzT(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<SessionDataSet> arrayList2 = new ArrayList<SessionDataSet>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.zzase;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzx.zzb(this.zzase.contains(session), "Attempting to read data for session %s which was not returned", session);
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzatm) {
            if (!zzw.equal(session, sessionDataSet.getSession()) || !dataType.equals(sessionDataSet.zzsA().getDataType())) continue;
            arrayList.add(sessionDataSet.zzsA());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzx.zzb(this.zzase.contains(session), "Attempting to read data for session %s which was not returned", session);
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzatm) {
            if (!zzw.equal(session, sessionDataSet.getSession())) continue;
            arrayList.add(sessionDataSet.zzsA());
        }
        return arrayList;
    }

    public List<SessionDataSet> zztt() {
        return this.zzatm;
    }

    @Override
    public Status getStatus() {
        return this.zzSC;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SessionReadResult && this.zzb((SessionReadResult)that);
    }

    private boolean zzb(SessionReadResult sessionReadResult) {
        return this.zzSC.equals(sessionReadResult.zzSC) && zzw.equal(this.zzase, sessionReadResult.zzase) && zzw.equal(this.zzatm, sessionReadResult.zzatm);
    }

    public int hashCode() {
        return zzw.hashCode(this.zzSC, this.zzase, this.zzatm);
    }

    public String toString() {
        return zzw.zzv(this).zzg("status", this.zzSC).zzg("sessions", this.zzase).zzg("sessionDataSets", this.zzatm).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzj.zza(this, dest, flags);
    }
}

