/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.zzj;
import com.google.android.gms.fitness.service.SensorEventDispatcher;
import com.google.android.gms.fitness.service.zza;
import com.google.android.gms.fitness.service.zzb;
import java.util.concurrent.TimeUnit;

public class FitnessSensorServiceRequest
implements SafeParcelable {
    public static final int UNSPECIFIED = -1;
    private final int mVersionCode;
    private final DataSource zzapM;
    private final zzj zzasF;
    private final long zzatp;
    private final long zzatq;
    public static final Parcelable.Creator<FitnessSensorServiceRequest> CREATOR = new zza();

    FitnessSensorServiceRequest(int versionCode, DataSource dataSource, IBinder listenerBinder, long samplingRateMicros, long batchIntervalMicros) {
        this.mVersionCode = versionCode;
        this.zzapM = dataSource;
        this.zzasF = zzj.zza.zzbl(listenerBinder);
        this.zzatp = samplingRateMicros;
        this.zzatq = batchIntervalMicros;
    }

    public DataSource getDataSource() {
        return this.zzapM;
    }

    public SensorEventDispatcher getDispatcher() {
        return new zzb(this.zzasF);
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return this.zzatp == -1L ? -1L : timeUnit.convert(this.zzatp, TimeUnit.MICROSECONDS);
    }

    public long getBatchInterval(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzatq, TimeUnit.MICROSECONDS);
    }

    public String toString() {
        return String.format("FitnessSensorServiceRequest{%s}", this.zzapM);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zztf() {
        return this.zzasF.asBinder();
    }

    public long zzsB() {
        return this.zzatp;
    }

    public long zztw() {
        return this.zzatq;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zza.zza(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof FitnessSensorServiceRequest && this.zza((FitnessSensorServiceRequest)that);
    }

    private boolean zza(FitnessSensorServiceRequest fitnessSensorServiceRequest) {
        return zzw.equal(this.zzapM, fitnessSensorServiceRequest.zzapM) && this.zzatp == fitnessSensorServiceRequest.zzatp && this.zzatq == fitnessSensorServiceRequest.zzatq;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzapM, this.zzatp, this.zzatq);
    }
}

