/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.zzmo;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzUM;
    private final String zzTa;
    private final String zzatr;
    private final String zzats;
    private final String zzaqZ;
    private final String zzatt;
    private final Uri zzatu;
    private final Uri zzatv;
    private final Uri zzatw;
    private final boolean zzatx;
    private final boolean zzaty;
    private final String zzatz;
    private final int zzatA;
    private final int zzatB;
    private final int zzatC;
    private final boolean zzatD;
    private final boolean zzatE;
    private final String zzatF;
    private final String zzatG;
    private final String zzatH;
    private final boolean zzBa;
    private final boolean zzatI;
    private final boolean zzatJ;
    private final String zzatK;
    private final boolean zzatL;

    public GameEntity(Game game) {
        this.mVersionCode = 7;
        this.zzUM = game.getApplicationId();
        this.zzatr = game.getPrimaryCategory();
        this.zzats = game.getSecondaryCategory();
        this.zzaqZ = game.getDescription();
        this.zzatt = game.getDeveloperName();
        this.zzTa = game.getDisplayName();
        this.zzatu = game.getIconImageUri();
        this.zzatF = game.getIconImageUrl();
        this.zzatv = game.getHiResImageUri();
        this.zzatG = game.getHiResImageUrl();
        this.zzatw = game.getFeaturedImageUri();
        this.zzatH = game.getFeaturedImageUrl();
        this.zzatx = game.zztx();
        this.zzaty = game.zztz();
        this.zzatz = game.zztA();
        this.zzatA = game.zztB();
        this.zzatB = game.getAchievementTotalCount();
        this.zzatC = game.getLeaderboardCount();
        this.zzatD = game.isRealTimeMultiplayerEnabled();
        this.zzatE = game.isTurnBasedMultiplayerEnabled();
        this.zzBa = game.isMuted();
        this.zzatI = game.zzty();
        this.zzatJ = game.areSnapshotsEnabled();
        this.zzatK = game.getThemeColor();
        this.zzatL = game.hasGamepadSupport();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled, String themeColor, boolean hasGamepadSupport) {
        this.mVersionCode = versionCode;
        this.zzUM = applicationId;
        this.zzTa = displayName;
        this.zzatr = primaryCategory;
        this.zzats = secondaryCategory;
        this.zzaqZ = description;
        this.zzatt = developerName;
        this.zzatu = iconImageUri;
        this.zzatF = iconImageUrl;
        this.zzatv = hiResImageUri;
        this.zzatG = hiResImageUrl;
        this.zzatw = featuredImageUri;
        this.zzatH = featuredImageUrl;
        this.zzatx = playEnabledGame;
        this.zzaty = instanceInstalled;
        this.zzatz = instancePackageName;
        this.zzatA = gameplayAclStatus;
        this.zzatB = achievementTotalCount;
        this.zzatC = leaderboardCount;
        this.zzatD = realTimeEnabled;
        this.zzatE = turnBasedEnabled;
        this.zzBa = muted;
        this.zzatI = identitySharingConfirmed;
        this.zzatJ = snapshotsEnabled;
        this.zzatK = themeColor;
        this.zzatL = hasGamepadSupport;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getApplicationId() {
        return this.zzUM;
    }

    @Override
    public String getDisplayName() {
        return this.zzTa;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzmo.zzb(this.zzTa, dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.zzatr;
    }

    @Override
    public String getSecondaryCategory() {
        return this.zzats;
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzmo.zzb(this.zzaqZ, dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.zzatt;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        zzmo.zzb(this.zzatt, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzatu;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzatF;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzatv;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzatG;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzatw;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.zzatH;
    }

    @Override
    public boolean isMuted() {
        return this.zzBa;
    }

    @Override
    public boolean zzty() {
        return this.zzatI;
    }

    @Override
    public boolean zztx() {
        return this.zzatx;
    }

    @Override
    public boolean zztz() {
        return this.zzaty;
    }

    @Override
    public String zztA() {
        return this.zzatz;
    }

    @Override
    public int zztB() {
        return this.zzatA;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.zzatB;
    }

    @Override
    public int getLeaderboardCount() {
        return this.zzatC;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.zzatD;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.zzatE;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.zzatJ;
    }

    @Override
    public String getThemeColor() {
        return this.zzatK;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.zzatL;
    }

    @Override
    public Game freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzw.hashCode(game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zztx(), game.zztz(), game.zztA(), game.zztB(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzty(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport());
    }

    public boolean equals(Object obj) {
        return GameEntity.zza(this, obj);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzw.equal(game2.getApplicationId(), game.getApplicationId()) && zzw.equal(game2.getDisplayName(), game.getDisplayName()) && zzw.equal(game2.getPrimaryCategory(), game.getPrimaryCategory()) && zzw.equal(game2.getSecondaryCategory(), game.getSecondaryCategory()) && zzw.equal(game2.getDescription(), game.getDescription()) && zzw.equal(game2.getDeveloperName(), game.getDeveloperName()) && zzw.equal(game2.getIconImageUri(), game.getIconImageUri()) && zzw.equal(game2.getHiResImageUri(), game.getHiResImageUri()) && zzw.equal(game2.getFeaturedImageUri(), game.getFeaturedImageUri()) && zzw.equal(game2.zztx(), game.zztx()) && zzw.equal(game2.zztz(), game.zztz()) && zzw.equal(game2.zztA(), game.zztA()) && zzw.equal(game2.zztB(), game.zztB()) && zzw.equal(game2.getAchievementTotalCount(), game.getAchievementTotalCount()) && zzw.equal(game2.getLeaderboardCount(), game.getLeaderboardCount()) && zzw.equal(game2.isRealTimeMultiplayerEnabled(), game.isRealTimeMultiplayerEnabled()) && zzw.equal(game2.isTurnBasedMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled() && zzw.equal(game2.isMuted(), game.isMuted()) && zzw.equal(game2.zzty(), game.zzty())) && zzw.equal(game2.areSnapshotsEnabled(), game.areSnapshotsEnabled()) && zzw.equal(game2.getThemeColor(), game.getThemeColor()) && zzw.equal(game2.hasGamepadSupport(), game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzw.zzv(game).zzg("ApplicationId", game.getApplicationId()).zzg("DisplayName", game.getDisplayName()).zzg("PrimaryCategory", game.getPrimaryCategory()).zzg("SecondaryCategory", game.getSecondaryCategory()).zzg("Description", game.getDescription()).zzg("DeveloperName", game.getDeveloperName()).zzg("IconImageUri", game.getIconImageUri()).zzg("IconImageUrl", game.getIconImageUrl()).zzg("HiResImageUri", game.getHiResImageUri()).zzg("HiResImageUrl", game.getHiResImageUrl()).zzg("FeaturedImageUri", game.getFeaturedImageUri()).zzg("FeaturedImageUrl", game.getFeaturedImageUrl()).zzg("PlayEnabledGame", game.zztx()).zzg("InstanceInstalled", game.zztz()).zzg("InstancePackageName", game.zztA()).zzg("AchievementTotalCount", game.getAchievementTotalCount()).zzg("LeaderboardCount", game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", game.areSnapshotsEnabled()).zzg("ThemeColor", game.getThemeColor()).zzg("HasGamepadSupport", game.hasGamepadSupport()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzoU()) {
            GameEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzUM);
            dest.writeString(this.zzTa);
            dest.writeString(this.zzatr);
            dest.writeString(this.zzats);
            dest.writeString(this.zzaqZ);
            dest.writeString(this.zzatt);
            dest.writeString(this.zzatu == null ? null : this.zzatu.toString());
            dest.writeString(this.zzatv == null ? null : this.zzatv.toString());
            dest.writeString(this.zzatw == null ? null : this.zzatw.toString());
            dest.writeInt(this.zzatx ? 1 : 0);
            dest.writeInt(this.zzaty ? 1 : 0);
            dest.writeString(this.zzatz);
            dest.writeInt(this.zzatA);
            dest.writeInt(this.zzatB);
            dest.writeInt(this.zzatC);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzdN(Parcel parcel) {
            boolean bl = GameEntity.zzd(GameEntity.zzoT());
            if (bl || GameEntity.zzck(GameEntity.class.getCanonicalName())) {
                return super.zzdN(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            String string8 = parcel.readString();
            Uri uri = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri2 = string9 == null ? null : Uri.parse((String)string9);
            String string10 = parcel.readString();
            Uri uri3 = string10 == null ? null : Uri.parse((String)string10);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string11 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            String string12 = null;
            String string13 = null;
            String string14 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            String string15 = null;
            boolean bl9 = false;
            return new GameEntity(7, string2, string3, string4, string5, string6, string7, uri, uri2, uri3, bl2, bl3, string11, n, n2, n3, bl4, bl5, string12, string13, string14, bl6, bl7, bl8, string15, bl9);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdN(x0);
        }
    }
}

