/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.PlayerLevelCreator;

public final class PlayerLevel
implements SafeParcelable {
    public static final Parcelable.Creator<PlayerLevel> CREATOR = new PlayerLevelCreator();
    private final int mVersionCode;
    private final int zzauh;
    private final long zzaui;
    private final long zzauj;

    public PlayerLevel(int value, long minXp, long maxXp) {
        this(1, value, minXp, maxXp);
    }

    PlayerLevel(int versionCode, int levelNumber, long minXp, long maxXp) {
        zzx.zza(minXp >= 0L, (Object)"Min XP must be positive!");
        zzx.zza(maxXp > minXp, (Object)"Max XP must be more than min XP!");
        this.mVersionCode = versionCode;
        this.zzauh = levelNumber;
        this.zzaui = minXp;
        this.zzauj = maxXp;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getLevelNumber() {
        return this.zzauh;
    }

    public long getMinXp() {
        return this.zzaui;
    }

    public long getMaxXp() {
        return this.zzauj;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzauh, this.zzaui, this.zzauj);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PlayerLevel playerLevel = (PlayerLevel)obj;
        return zzw.equal(playerLevel.getLevelNumber(), this.getLevelNumber()) && zzw.equal(playerLevel.getMinXp(), this.getMinXp()) && zzw.equal(playerLevel.getMaxXp(), this.getMaxXp());
    }

    public String toString() {
        return zzw.zzv(this).zzg("LevelNumber", this.getLevelNumber()).zzg("MinXp", this.getMinXp()).zzg("MaxXp", this.getMaxXp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelCreator.zza(this, out, flags);
    }
}

