/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfoCreator;

public final class PlayerLevelInfo
implements SafeParcelable {
    public static final Parcelable.Creator<PlayerLevelInfo> CREATOR = new PlayerLevelInfoCreator();
    private final int mVersionCode;
    private final long zzauk;
    private final long zzaul;
    private final PlayerLevel zzaum;
    private final PlayerLevel zzaun;

    public PlayerLevelInfo(long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        this(1, currentXpTotal, lastLevelUpTimestamp, currentLevel, nextLevel);
    }

    PlayerLevelInfo(int versionCode, long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        zzx.zzZ(currentXpTotal != -1L);
        zzx.zzw(currentLevel);
        zzx.zzw(nextLevel);
        this.mVersionCode = versionCode;
        this.zzauk = currentXpTotal;
        this.zzaul = lastLevelUpTimestamp;
        this.zzaum = currentLevel;
        this.zzaun = nextLevel;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public long getCurrentXpTotal() {
        return this.zzauk;
    }

    public long getLastLevelUpTimestamp() {
        return this.zzaul;
    }

    public PlayerLevel getCurrentLevel() {
        return this.zzaum;
    }

    public PlayerLevel getNextLevel() {
        return this.zzaun;
    }

    public boolean isMaxLevel() {
        return this.zzaum.equals(this.zzaun);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevelInfo)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PlayerLevelInfo playerLevelInfo = (PlayerLevelInfo)obj;
        return zzw.equal(this.zzauk, playerLevelInfo.zzauk) && zzw.equal(this.zzaul, playerLevelInfo.zzaul) && zzw.equal(this.zzaum, playerLevelInfo.zzaum) && zzw.equal(this.zzaun, playerLevelInfo.zzaun);
    }

    public int hashCode() {
        return zzw.hashCode(this.zzauk, this.zzaul, this.zzaum, this.zzaun);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelInfoCreator.zza(this, out, flags);
    }
}

