/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames zzauo;
    private final PlayerLevelInfo zzaud;
    private final MostRecentGameInfoRef zzaup;

    public PlayerRef(DataHolder holder, int dataRow) {
        this(holder, dataRow, null);
    }

    public PlayerRef(DataHolder holder, int dataRow, String prefix) {
        super(holder, dataRow);
        this.zzauo = new PlayerColumnNames(prefix);
        this.zzaup = new MostRecentGameInfoRef(holder, dataRow, this.zzauo);
        if (this.zztJ()) {
            PlayerLevel playerLevel;
            int n = this.getInteger(this.zzauo.zzazA);
            int n2 = this.getInteger(this.zzauo.zzazD);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n, this.getLong(this.zzauo.zzazB), this.getLong(this.zzauo.zzazC));
            if (n != n2) {
                playerLevel2 = new PlayerLevel(n2, this.getLong(this.zzauo.zzazC), this.getLong(this.zzauo.zzazE));
            }
            this.zzaud = new PlayerLevelInfo(this.getLong(this.zzauo.zzazz), this.getLong(this.zzauo.zzazF), playerLevel, playerLevel2);
        } else {
            this.zzaud = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.zzauo.zzazq);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.zzauo.zzazr);
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.zza(this.zzauo.zzazr, dataOut);
    }

    @Override
    public String zztE() {
        return this.getString(this.zzauo.zzazP);
    }

    @Override
    public String getName() {
        return this.getString(this.zzauo.name);
    }

    @Override
    public boolean zztF() {
        return this.getBoolean(this.zzauo.zzazO);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzcf(this.zzauo.zzazs);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.zzauo.zzazt);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzcf(this.zzauo.zzazu);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.zzauo.zzazv);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.zzauo.zzazw);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzce(this.zzauo.zzazy) || this.zzcg(this.zzauo.zzazy)) {
            return -1L;
        }
        return this.getLong(this.zzauo.zzazy);
    }

    @Override
    public int zztG() {
        return this.getInteger(this.zzauo.zzazx);
    }

    @Override
    public boolean zztH() {
        return this.getBoolean(this.zzauo.zzazH);
    }

    @Override
    public String getTitle() {
        return this.getString(this.zzauo.title);
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        this.zza(this.zzauo.title, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzaud;
    }

    @Override
    public MostRecentGameInfo zztI() {
        if (this.zzcg(this.zzauo.zzazI)) {
            return null;
        }
        return this.zzaup;
    }

    @Override
    public Player freeze() {
        return new PlayerEntity(this);
    }

    @Override
    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    @Override
    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        PlayerEntity playerEntity = (PlayerEntity)this.freeze();
        playerEntity.writeToParcel(dest, flags);
    }

    private boolean zztJ() {
        if (this.zzcg(this.zzauo.zzazz)) {
            return false;
        }
        return this.getLong(this.zzauo.zzazz) != -1L;
    }
}

