/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.appcontent;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.appcontent.AppContentAction;
import com.google.android.gms.games.appcontent.AppContentActionEntity;
import com.google.android.gms.games.appcontent.AppContentAnnotation;
import com.google.android.gms.games.appcontent.AppContentAnnotationEntity;
import com.google.android.gms.games.appcontent.AppContentCard;
import com.google.android.gms.games.appcontent.AppContentCardEntityCreator;
import com.google.android.gms.games.appcontent.AppContentCondition;
import com.google.android.gms.games.appcontent.AppContentConditionEntity;
import java.util.ArrayList;
import java.util.List;

public final class AppContentCardEntity
implements SafeParcelable,
AppContentCard {
    public static final AppContentCardEntityCreator CREATOR = new AppContentCardEntityCreator();
    private final int mVersionCode;
    private final ArrayList<AppContentActionEntity> mActions;
    private final ArrayList<AppContentAnnotationEntity> zzauM;
    private final ArrayList<AppContentConditionEntity> zzauC;
    private final String zzauD;
    private final int zzauN;
    private final String zzaqZ;
    private final Bundle mExtras;
    private final String zzauO;
    private final String zzajf;
    private final int zzauP;
    private final String zzGq;
    private final String zzwN;

    public AppContentCardEntity(AppContentCard card) {
        this.mVersionCode = 4;
        this.zzauD = card.zztQ();
        this.zzauN = card.zzub();
        this.zzaqZ = card.getDescription();
        this.mExtras = card.getExtras();
        this.zzwN = card.getId();
        this.zzajf = card.getTitle();
        this.zzauO = card.zzuc();
        this.zzauP = card.zzud();
        this.zzGq = card.getType();
        List<AppContentAction> list = card.getActions();
        int n = list.size();
        this.mActions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.mActions.add((AppContentActionEntity)list.get(i).freeze());
        }
        List<AppContentAnnotation> list2 = card.zzua();
        int n2 = list2.size();
        this.zzauM = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            this.zzauM.add((AppContentAnnotationEntity)list2.get(i).freeze());
        }
        List<AppContentCondition> list3 = card.zztP();
        int n3 = list3.size();
        this.zzauC = new ArrayList(n3);
        for (int i = 0; i < n3; ++i) {
            this.zzauC.add((AppContentConditionEntity)list3.get(i).freeze());
        }
    }

    AppContentCardEntity(int versionCode, ArrayList<AppContentActionEntity> actions, ArrayList<AppContentAnnotationEntity> annotations, ArrayList<AppContentConditionEntity> conditions, String contentDescription, int currentProgress, String description, Bundle extras, String subtitle, String title, int totalProgress, String type, String id) {
        this.mVersionCode = versionCode;
        this.mActions = actions;
        this.zzauM = annotations;
        this.zzauC = conditions;
        this.zzauD = contentDescription;
        this.zzauN = currentProgress;
        this.zzaqZ = description;
        this.mExtras = extras;
        this.zzwN = id;
        this.zzauO = subtitle;
        this.zzajf = title;
        this.zzauP = totalProgress;
        this.zzGq = type;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public List<AppContentAction> getActions() {
        return new ArrayList<AppContentAction>(this.mActions);
    }

    @Override
    public List<AppContentAnnotation> zzua() {
        return new ArrayList<AppContentAnnotation>(this.zzauM);
    }

    @Override
    public List<AppContentCondition> zztP() {
        return new ArrayList<AppContentCondition>(this.zzauC);
    }

    @Override
    public String zztQ() {
        return this.zzauD;
    }

    @Override
    public int zzub() {
        return this.zzauN;
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public String getId() {
        return this.zzwN;
    }

    @Override
    public String zzuc() {
        return this.zzauO;
    }

    @Override
    public String getTitle() {
        return this.zzajf;
    }

    @Override
    public int zzud() {
        return this.zzauP;
    }

    @Override
    public String getType() {
        return this.zzGq;
    }

    public AppContentCard zzue() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AppContentCardEntity.zza(this);
    }

    static int zza(AppContentCard appContentCard) {
        return zzw.hashCode(appContentCard.getActions(), appContentCard.zzua(), appContentCard.zztP(), appContentCard.zztQ(), appContentCard.zzub(), appContentCard.getDescription(), appContentCard.getExtras(), appContentCard.getId(), appContentCard.zzuc(), appContentCard.getTitle(), appContentCard.zzud(), appContentCard.getType());
    }

    public boolean equals(Object obj) {
        return AppContentCardEntity.zza(this, obj);
    }

    static boolean zza(AppContentCard appContentCard, Object object) {
        if (!(object instanceof AppContentCard)) {
            return false;
        }
        if (appContentCard == object) {
            return true;
        }
        AppContentCard appContentCard2 = (AppContentCard)object;
        return zzw.equal(appContentCard2.getActions(), appContentCard.getActions()) && zzw.equal(appContentCard2.zzua(), appContentCard.zzua()) && zzw.equal(appContentCard2.zztP(), appContentCard.zztP()) && zzw.equal(appContentCard2.zztQ(), appContentCard.zztQ()) && zzw.equal(appContentCard2.zzub(), appContentCard.zzub()) && zzw.equal(appContentCard2.getDescription(), appContentCard.getDescription()) && zzw.equal(appContentCard2.getExtras(), appContentCard.getExtras()) && zzw.equal(appContentCard2.getId(), appContentCard.getId()) && zzw.equal(appContentCard2.zzuc(), appContentCard.zzuc()) && zzw.equal(appContentCard2.getTitle(), appContentCard.getTitle()) && zzw.equal(appContentCard2.zzud(), appContentCard.zzud()) && zzw.equal(appContentCard2.getType(), appContentCard.getType());
    }

    public String toString() {
        return AppContentCardEntity.zzb(this);
    }

    static String zzb(AppContentCard appContentCard) {
        return zzw.zzv(appContentCard).zzg("Actions", appContentCard.getActions()).zzg("Annotations", appContentCard.zzua()).zzg("Conditions", appContentCard.zztP()).zzg("ContentDescription", appContentCard.zztQ()).zzg("CurrentSteps", appContentCard.zzub()).zzg("Description", appContentCard.getDescription()).zzg("Extras", appContentCard.getExtras()).zzg("Id", appContentCard.getId()).zzg("Subtitle", appContentCard.zzuc()).zzg("Title", appContentCard.getTitle()).zzg("TotalSteps", appContentCard.zzud()).zzg("Type", appContentCard.getType()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        AppContentCardEntityCreator.zza(this, out, flags);
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.zzue();
    }
}

