/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.appcontent;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.appcontent.AppContentAction;
import com.google.android.gms.games.appcontent.AppContentActionEntity;
import com.google.android.gms.games.appcontent.AppContentAnnotation;
import com.google.android.gms.games.appcontent.AppContentAnnotationEntity;
import com.google.android.gms.games.appcontent.AppContentCard;
import com.google.android.gms.games.appcontent.AppContentCardEntity;
import com.google.android.gms.games.appcontent.AppContentSection;
import com.google.android.gms.games.appcontent.AppContentSectionEntityCreator;
import java.util.ArrayList;
import java.util.List;

public final class AppContentSectionEntity
implements SafeParcelable,
AppContentSection {
    public static final AppContentSectionEntityCreator CREATOR = new AppContentSectionEntityCreator();
    private final int mVersionCode;
    private final ArrayList<AppContentActionEntity> mActions;
    private final ArrayList<AppContentCardEntity> zzauV;
    private final String zzauD;
    private final Bundle mExtras;
    private final String zzauO;
    private final String zzajf;
    private final String zzGq;
    private final String zzwN;
    private final String zzauW;
    private final ArrayList<AppContentAnnotationEntity> zzauM;

    public AppContentSectionEntity(AppContentSection section) {
        this.mVersionCode = 5;
        this.zzauW = section.zzul();
        this.zzauD = section.zztQ();
        this.mExtras = section.getExtras();
        this.zzwN = section.getId();
        this.zzauO = section.zzuc();
        this.zzajf = section.getTitle();
        this.zzGq = section.getType();
        List<AppContentAction> list = section.getActions();
        int n = list.size();
        this.mActions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.mActions.add((AppContentActionEntity)list.get(i).freeze());
        }
        List<AppContentCard> list2 = section.zzuk();
        n = list2.size();
        this.zzauV = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzauV.add((AppContentCardEntity)list2.get(i).freeze());
        }
        List<AppContentAnnotation> list3 = section.zzua();
        n = list3.size();
        this.zzauM = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzauM.add((AppContentAnnotationEntity)list3.get(i).freeze());
        }
    }

    AppContentSectionEntity(int versionCode, ArrayList<AppContentActionEntity> actions, ArrayList<AppContentCardEntity> cards, String contentDescription, Bundle extras, String subtitle, String title, String type, String id, String cardType, ArrayList<AppContentAnnotationEntity> annotations) {
        this.mVersionCode = versionCode;
        this.mActions = actions;
        this.zzauM = annotations;
        this.zzauV = cards;
        this.zzauW = cardType;
        this.zzauD = contentDescription;
        this.mExtras = extras;
        this.zzwN = id;
        this.zzauO = subtitle;
        this.zzajf = title;
        this.zzGq = type;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public List<AppContentAction> getActions() {
        return new ArrayList<AppContentAction>(this.mActions);
    }

    @Override
    public List<AppContentAnnotation> zzua() {
        return new ArrayList<AppContentAnnotation>(this.zzauM);
    }

    @Override
    public List<AppContentCard> zzuk() {
        return new ArrayList<AppContentCard>(this.zzauV);
    }

    @Override
    public String zzul() {
        return this.zzauW;
    }

    @Override
    public String zztQ() {
        return this.zzauD;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public String zzuc() {
        return this.zzauO;
    }

    @Override
    public String getId() {
        return this.zzwN;
    }

    @Override
    public String getTitle() {
        return this.zzajf;
    }

    @Override
    public String getType() {
        return this.zzGq;
    }

    public AppContentSection zzum() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AppContentSectionEntity.zza(this);
    }

    static int zza(AppContentSection appContentSection) {
        return zzw.hashCode(appContentSection.getActions(), appContentSection.zzua(), appContentSection.zzuk(), appContentSection.zzul(), appContentSection.zztQ(), appContentSection.getExtras(), appContentSection.getId(), appContentSection.zzuc(), appContentSection.getTitle(), appContentSection.getType());
    }

    public boolean equals(Object obj) {
        return AppContentSectionEntity.zza(this, obj);
    }

    static boolean zza(AppContentSection appContentSection, Object object) {
        if (!(object instanceof AppContentSection)) {
            return false;
        }
        if (appContentSection == object) {
            return true;
        }
        AppContentSection appContentSection2 = (AppContentSection)object;
        return zzw.equal(appContentSection2.getActions(), appContentSection.getActions()) && zzw.equal(appContentSection2.zzua(), appContentSection.zzua()) && zzw.equal(appContentSection2.zzuk(), appContentSection.zzuk()) && zzw.equal(appContentSection2.zzul(), appContentSection.zzul()) && zzw.equal(appContentSection2.zztQ(), appContentSection.zztQ()) && zzw.equal(appContentSection2.getExtras(), appContentSection.getExtras()) && zzw.equal(appContentSection2.getId(), appContentSection.getId()) && zzw.equal(appContentSection2.zzuc(), appContentSection.zzuc()) && zzw.equal(appContentSection2.getTitle(), appContentSection.getTitle()) && zzw.equal(appContentSection2.getType(), appContentSection.getType());
    }

    public String toString() {
        return AppContentSectionEntity.zzb(this);
    }

    static String zzb(AppContentSection appContentSection) {
        return zzw.zzv(appContentSection).zzg("Actions", appContentSection.getActions()).zzg("Annotations", appContentSection.zzua()).zzg("Cards", appContentSection.zzuk()).zzg("CardType", appContentSection.zzul()).zzg("ContentDescription", appContentSection.zztQ()).zzg("Extras", appContentSection.getExtras()).zzg("Id", appContentSection.getId()).zzg("Subtitle", appContentSection.zzuc()).zzg("Title", appContentSection.getTitle()).zzg("Type", appContentSection.getType()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        AppContentSectionEntityCreator.zza(this, out, flags);
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.zzum();
    }
}

