/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.zzmo;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int mVersionCode;
    private final String zzavb;
    private final String mName;
    private final String zzaqZ;
    private final Uri zzatu;
    private final String zzatF;
    private final PlayerEntity zzaux;
    private final long zzavc;
    private final String zzavd;
    private final boolean zzave;

    public EventEntity(Event event) {
        this.mVersionCode = 1;
        this.zzavb = event.getEventId();
        this.mName = event.getName();
        this.zzaqZ = event.getDescription();
        this.zzatu = event.getIconImageUri();
        this.zzatF = event.getIconImageUrl();
        this.zzaux = (PlayerEntity)event.getPlayer().freeze();
        this.zzavc = event.getValue();
        this.zzavd = event.getFormattedValue();
        this.zzave = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.mVersionCode = versionCode;
        this.zzavb = eventId;
        this.mName = name;
        this.zzaqZ = description;
        this.zzatu = iconImageUri;
        this.zzatF = iconImageUrl;
        this.zzaux = new PlayerEntity(player);
        this.zzavc = value;
        this.zzavd = formattedValue;
        this.zzave = isVisible;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.zzavb;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzmo.zzb(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzmo.zzb(this.zzaqZ, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzatu;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzatF;
    }

    @Override
    public Player getPlayer() {
        return this.zzaux;
    }

    @Override
    public long getValue() {
        return this.zzavc;
    }

    @Override
    public String getFormattedValue() {
        return this.zzavd;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        zzmo.zzb(this.zzavd, dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.zzave;
    }

    @Override
    public Event freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzw.hashCode(event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible());
    }

    public boolean equals(Object obj) {
        return EventEntity.zza(this, obj);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzw.equal(event2.getEventId(), event.getEventId()) && zzw.equal(event2.getName(), event.getName()) && zzw.equal(event2.getDescription(), event.getDescription()) && zzw.equal(event2.getIconImageUri(), event.getIconImageUri()) && zzw.equal(event2.getIconImageUrl(), event.getIconImageUrl()) && zzw.equal(event2.getPlayer(), event.getPlayer()) && zzw.equal(event2.getValue(), event.getValue()) && zzw.equal(event2.getFormattedValue(), event.getFormattedValue()) && zzw.equal(event2.isVisible(), event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzw.zzv(event).zzg("Id", event.getEventId()).zzg("Name", event.getName()).zzg("Description", event.getDescription()).zzg("IconImageUri", event.getIconImageUri()).zzg("IconImageUrl", event.getIconImageUrl()).zzg("Player", event.getPlayer()).zzg("Value", event.getValue()).zzg("FormattedValue", event.getFormattedValue()).zzg("isVisible", event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.zza(this, out, flags);
    }
}

