/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.zzlm;
import java.util.List;

public final class RealTimeMultiplayerImpl
implements RealTimeMultiplayer {
    @Override
    public Intent getWaitingRoomIntent(GoogleApiClient apiClient, Room room, int minParticipantsToStart) {
        return Games.zzc(apiClient).zza(room, minParticipantsToStart);
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers) {
        return Games.zzc(apiClient).zzc(minPlayers, maxPlayers, true);
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers, boolean allowAutomatch) {
        return Games.zzc(apiClient).zzc(minPlayers, maxPlayers, allowAutomatch);
    }

    @Override
    public void create(GoogleApiClient apiClient, RoomConfig config) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl == null) {
            return;
        }
        zzlm<RoomUpdateListener> zzlm2 = apiClient.zzo(config.getRoomUpdateListener());
        zzlm<RoomStatusUpdateListener> zzlm3 = RealTimeMultiplayerImpl.zza(apiClient, config.getRoomStatusUpdateListener());
        zzlm<RealTimeMessageReceivedListener> zzlm4 = RealTimeMultiplayerImpl.zza(apiClient, config.getMessageReceivedListener());
        gamesClientImpl.zza(zzlm2, zzlm3, zzlm4, config);
    }

    @Override
    public void join(GoogleApiClient apiClient, RoomConfig config) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl == null) {
            return;
        }
        zzlm<RoomUpdateListener> zzlm2 = apiClient.zzo(config.getRoomUpdateListener());
        zzlm<RoomStatusUpdateListener> zzlm3 = RealTimeMultiplayerImpl.zza(apiClient, config.getRoomStatusUpdateListener());
        zzlm<RealTimeMessageReceivedListener> zzlm4 = RealTimeMultiplayerImpl.zza(apiClient, config.getMessageReceivedListener());
        gamesClientImpl.zzb(zzlm2, zzlm3, zzlm4, config);
    }

    @Override
    public void leave(GoogleApiClient apiClient, RoomUpdateListener listener, String roomId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            zzlm<RoomUpdateListener> zzlm2 = apiClient.zzo(listener);
            gamesClientImpl.zza(zzlm2, roomId);
        }
    }

    @Override
    public int sendReliableMessage(GoogleApiClient apiClient, RealTimeMultiplayer.ReliableMessageSentCallback callback, byte[] messageData, String roomId, String recipientParticipantId) {
        zzlm<RealTimeMultiplayer.ReliableMessageSentCallback> zzlm2 = RealTimeMultiplayerImpl.zza(apiClient, callback);
        return Games.zzc(apiClient).zza(zzlm2, messageData, roomId, recipientParticipantId);
    }

    @Override
    public int sendUnreliableMessage(GoogleApiClient apiClient, byte[] messageData, String roomId, String recipientParticipantId) {
        return Games.zzc(apiClient).zza(messageData, roomId, new String[]{recipientParticipantId});
    }

    @Override
    public int sendUnreliableMessage(GoogleApiClient apiClient, byte[] messageData, String roomId, List<String> recipientParticipantIds) {
        String[] stringArray = recipientParticipantIds.toArray(new String[recipientParticipantIds.size()]);
        return Games.zzc(apiClient).zza(messageData, roomId, stringArray);
    }

    @Override
    public int sendUnreliableMessageToOthers(GoogleApiClient apiClient, byte[] messageData, String roomId) {
        return Games.zzc(apiClient).zzd(messageData, roomId);
    }

    @Override
    public void declineInvitation(GoogleApiClient apiClient, String invitationId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzr(invitationId, 0);
        }
    }

    @Override
    public void dismissInvitation(GoogleApiClient apiClient, String invitationId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzq(invitationId, 0);
        }
    }

    private static <L> zzlm<L> zza(GoogleApiClient googleApiClient, L l2) {
        if (l2 == null) {
            return null;
        }
        return googleApiClient.zzo(l2);
    }
}

