/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.internal.zzlm;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class RequestsImpl
implements Requests {
    @Override
    public void registerRequestListener(GoogleApiClient apiClient, OnRequestReceivedListener listener) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            zzlm<OnRequestReceivedListener> zzlm2 = apiClient.zzo(listener);
            gamesClientImpl.zzd(zzlm2);
        }
    }

    @Override
    public void unregisterRequestListener(GoogleApiClient apiClient) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzuI();
        }
    }

    @Override
    public Intent getInboxIntent(GoogleApiClient apiClient) {
        return Games.zzc(apiClient).zzuO();
    }

    @Override
    public Intent getSendIntent(GoogleApiClient apiClient, int type, byte[] payload, int requestLifetimeDays, Bitmap icon, String description) {
        return Games.zzc(apiClient).zza(type, payload, requestLifetimeDays, icon, description);
    }

    @Override
    public int getMaxPayloadSize(GoogleApiClient apiClient) {
        return Games.zzc(apiClient).zzuP();
    }

    @Override
    public int getMaxLifetimeDays(GoogleApiClient apiClient) {
        return Games.zzc(apiClient).zzuQ();
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> acceptRequest(GoogleApiClient apiClient, String requestId) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(requestId);
        return this.acceptRequests(apiClient, arrayList);
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> acceptRequests(GoogleApiClient apiClient, List<String> requestIds) {
        final String[] stringArray = requestIds == null ? null : requestIds.toArray(new String[requestIds.size()]);
        return apiClient.zzb(new UpdateRequestsImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb(this, stringArray);
            }
        });
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> dismissRequest(GoogleApiClient apiClient, String requestId) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(requestId);
        return this.dismissRequests(apiClient, arrayList);
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> dismissRequests(GoogleApiClient apiClient, List<String> requestIds) {
        final String[] stringArray = requestIds == null ? null : requestIds.toArray(new String[requestIds.size()]);
        return apiClient.zzb(new UpdateRequestsImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzc(this, stringArray);
            }
        });
    }

    @Override
    public PendingResult<Requests.LoadRequestsResult> loadRequests(GoogleApiClient apiClient, final int requestDirection, final int types, final int sortOrder) {
        return apiClient.zza(new LoadRequestsImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza(this, requestDirection, types, sortOrder);
            }
        });
    }

    @Override
    public ArrayList<GameRequest> getGameRequestsFromInboxResponse(Intent response) {
        if (response == null) {
            return new ArrayList<GameRequest>();
        }
        return this.getGameRequestsFromBundle(response.getExtras());
    }

    @Override
    public ArrayList<GameRequest> getGameRequestsFromBundle(Bundle extras) {
        if (extras == null || !extras.containsKey("requests")) {
            return new ArrayList<GameRequest>();
        }
        ArrayList arrayList = (ArrayList)extras.get("requests");
        ArrayList<GameRequest> arrayList2 = new ArrayList<GameRequest>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList2.add((GameRequest)arrayList.get(i));
        }
        return arrayList2;
    }

    private static abstract class LoadRequestSummariesImpl
    extends Games.BaseGamesApiMethodImpl<Requests.LoadRequestSummariesResult> {
        public Requests.LoadRequestSummariesResult zzav(final Status status) {
            return new Requests.LoadRequestSummariesResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public void release() {
                }
            };
        }

        @Override
        public /* synthetic */ Result zzb(Status status) {
            return this.zzav(status);
        }
    }

    private static abstract class SendRequestImpl
    extends Games.BaseGamesApiMethodImpl<Requests.SendRequestResult> {
        public Requests.SendRequestResult zzax(final Status status) {
            return new Requests.SendRequestResult(){

                @Override
                public Status getStatus() {
                    return status;
                }
            };
        }

        @Override
        public /* synthetic */ Result zzb(Status status) {
            return this.zzax(status);
        }
    }

    private static abstract class UpdateRequestsImpl
    extends Games.BaseGamesApiMethodImpl<Requests.UpdateRequestsResult> {
        private UpdateRequestsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Requests.UpdateRequestsResult zzay(final Status status) {
            return new Requests.UpdateRequestsResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public void release() {
                }

                @Override
                public int getRequestOutcome(String requestId) {
                    throw new IllegalArgumentException("Unknown request ID " + requestId);
                }

                @Override
                public Set<String> getRequestIds() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result zzb(Status status) {
            return this.zzay(status);
        }
    }

    private static abstract class LoadRequestsImpl
    extends Games.BaseGamesApiMethodImpl<Requests.LoadRequestsResult> {
        private LoadRequestsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Requests.LoadRequestsResult zzaw(final Status status) {
            return new Requests.LoadRequestsResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public void release() {
                }

                @Override
                public GameRequestBuffer getRequests(int type) {
                    int n = status.getStatusCode();
                    return new GameRequestBuffer(DataHolder.zzbu(n));
                }
            };
        }

        @Override
        public /* synthetic */ Result zzb(Status status) {
            return this.zzaw(status);
        }
    }
}

