/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntityCreator;

public final class GameBadgeEntity
extends GamesDowngradeableSafeParcel
implements GameBadge {
    public static final GameBadgeEntityCreator CREATOR = new GameBadgeEntityCreatorCompat();
    private final int mVersionCode;
    private int zzWJ;
    private String zzajf;
    private String zzaqZ;
    private Uri zzatu;

    public GameBadgeEntity(GameBadge gameBadge) {
        this.mVersionCode = 1;
        this.zzWJ = gameBadge.getType();
        this.zzajf = gameBadge.getTitle();
        this.zzaqZ = gameBadge.getDescription();
        this.zzatu = gameBadge.getIconImageUri();
    }

    GameBadgeEntity(int versionCode, int type, String title, String description, Uri iconImageUri) {
        this.mVersionCode = versionCode;
        this.zzWJ = type;
        this.zzajf = title;
        this.zzaqZ = description;
        this.zzatu = iconImageUri;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getType() {
        return this.zzWJ;
    }

    @Override
    public String getTitle() {
        return this.zzajf;
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzatu;
    }

    public GameBadge zzvk() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameBadgeEntity.zza(this);
    }

    static int zza(GameBadge gameBadge) {
        return zzw.hashCode(gameBadge.getType(), gameBadge.getTitle(), gameBadge.getDescription(), gameBadge.getIconImageUri());
    }

    public boolean equals(Object obj) {
        return GameBadgeEntity.zza(this, obj);
    }

    static boolean zza(GameBadge gameBadge, Object object) {
        if (!(object instanceof GameBadge)) {
            return false;
        }
        if (gameBadge == object) {
            return true;
        }
        GameBadge gameBadge2 = (GameBadge)object;
        return zzw.equal(gameBadge2.getType(), gameBadge.getTitle()) && zzw.equal(gameBadge2.getDescription(), gameBadge.getIconImageUri());
    }

    public String toString() {
        return GameBadgeEntity.zzb(this);
    }

    static String zzb(GameBadge gameBadge) {
        return zzw.zzv(gameBadge).zzg("Type", gameBadge.getType()).zzg("Title", gameBadge.getTitle()).zzg("Description", gameBadge.getDescription()).zzg("IconImageUri", gameBadge.getIconImageUri()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzoU()) {
            GameBadgeEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeInt(this.zzWJ);
            dest.writeString(this.zzajf);
            dest.writeString(this.zzaqZ);
            dest.writeString(this.zzatu == null ? null : this.zzatu.toString());
        }
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.zzvk();
    }

    static final class GameBadgeEntityCreatorCompat
    extends GameBadgeEntityCreator {
        GameBadgeEntityCreatorCompat() {
        }

        @Override
        public GameBadgeEntity zzea(Parcel parcel) {
            boolean bl = GameBadgeEntity.zzd(GameBadgeEntity.zzoT());
            if (bl || GameBadgeEntity.zzck(GameBadgeEntity.class.getCanonicalName())) {
                return super.zzea(parcel);
            }
            int n = parcel.readInt();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            return new GameBadgeEntity(1, n, string2, string3, uri);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzea(x0);
        }
    }
}

