/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.request;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.request.GameRequestClusterCreator;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntity;
import java.util.ArrayList;
import java.util.List;

public final class GameRequestCluster
implements SafeParcelable,
GameRequest {
    public static final GameRequestClusterCreator CREATOR = new GameRequestClusterCreator();
    private final int mVersionCode;
    private final ArrayList<GameRequestEntity> zzazQ;

    GameRequestCluster(int versionCode, ArrayList<GameRequestEntity> requestList) {
        this.mVersionCode = versionCode;
        this.zzazQ = requestList;
        this.zzvp();
    }

    private void zzvp() {
        zzb.zzZ(!this.zzazQ.isEmpty());
        GameRequest gameRequest = this.zzazQ.get(0);
        int n = this.zzazQ.size();
        for (int i = 1; i < n; ++i) {
            GameRequest gameRequest2 = this.zzazQ.get(i);
            zzb.zza(gameRequest.getType() == gameRequest2.getType(), "All the requests must be of the same type");
            zzb.zza(gameRequest.getSender().equals(gameRequest2.getSender()), "All the requests must be from the same sender");
        }
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public ArrayList<GameRequest> zzvD() {
        return new ArrayList<GameRequest>(this.zzazQ);
    }

    @Override
    public String getRequestId() {
        return this.zzazQ.get(0).getRequestId();
    }

    @Override
    public Game getGame() {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public Player getSender() {
        return this.zzazQ.get(0).getSender();
    }

    public ArrayList<Player> zzvE() {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public boolean isConsumed(String playerId) {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public byte[] getData() {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public int getType() {
        return this.zzazQ.get(0).getType();
    }

    @Override
    public long getCreationTimestamp() {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public long getExpirationTimestamp() {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public int getRecipientStatus(String playerId) {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public int getStatus() {
        throw new UnsupportedOperationException("Method not supported on a cluster");
    }

    @Override
    public GameRequest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GameRequestCluster)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GameRequestCluster gameRequestCluster = (GameRequestCluster)obj;
        if (gameRequestCluster.zzazQ.size() != this.zzazQ.size()) {
            return false;
        }
        int n = this.zzazQ.size();
        for (int i = 0; i < n; ++i) {
            GameRequest gameRequest;
            GameRequest gameRequest2 = this.zzazQ.get(i);
            if (gameRequest2.equals(gameRequest = (GameRequest)gameRequestCluster.zzazQ.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return zzw.hashCode(this.zzazQ.toArray());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestClusterCreator.zza(this, dest, flags);
    }

    public /* synthetic */ List getRecipients() {
        return this.zzvE();
    }
}

